/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.dir;

import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.common.DeletingFileVisitor;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory;

@CryptoFileSystemScoped
public class CiphertextDirectoryDeleter {
    private final DirectoryStreamFactory directoryStreamFactory;

    @Inject
    public CiphertextDirectoryDeleter(DirectoryStreamFactory directoryStreamFactory) {
        this.directoryStreamFactory = directoryStreamFactory;
    }

    public void deleteCiphertextDirIncludingNonCiphertextFiles(Path ciphertextDir, CryptoPath cleartextDir) throws IOException {
        try {
            DeletingFileVisitor.forceDeleteIfExists(ciphertextDir);
        }
        catch (DirectoryNotEmptyException e) {
            switch (this.deleteNonCiphertextFiles(ciphertextDir, cleartextDir)) {
                case NO_FILES_DELETED: {
                    throw e;
                }
                case SOME_FILES_DELETED: {
                    Files.delete(ciphertextDir);
                }
            }
        }
    }

    private DeleteResult deleteNonCiphertextFiles(Path ciphertextDir, CryptoPath cleartextDir) throws IOException {
        DeleteResult result = DeleteResult.NO_FILES_DELETED;
        Set<Path> ciphertextFiles = this.ciphertextFiles(cleartextDir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(ciphertextDir, p -> !ciphertextFiles.contains(p));){
            for (Path path : stream) {
                result = DeleteResult.SOME_FILES_DELETED;
                Files.walkFileTree(path, DeletingFileVisitor.INSTANCE);
            }
        }
        return result;
    }

    private Set<Path> ciphertextFiles(CryptoPath cleartextDir) throws IOException {
        try (CryptoDirectoryStream directoryStream = this.directoryStreamFactory.newDirectoryStream(cleartextDir, ignored -> true);){
            Set<Path> set = directoryStream.ciphertextDirectoryListing().collect(Collectors.toSet());
            return set;
        }
    }

    static enum DeleteResult {
        NO_FILES_DELETED,
        SOME_FILES_DELETED;

    }
}

