/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Provider;
import org.cryptomator.cryptofs.CopyOperation;
import org.cryptomator.cryptofs.CopyOperation_Factory;
import org.cryptomator.cryptofs.CryptoFileStore;
import org.cryptomator.cryptofs.CryptoFileStore_Factory;
import org.cryptomator.cryptofs.CryptoFileSystemComponent;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemImpl_Factory;
import org.cryptomator.cryptofs.CryptoFileSystemModule;
import org.cryptomator.cryptofs.CryptoFileSystemModule_ProvideNativeFileStoreFactory;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.CryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.CryptoFileSystemStats_Factory;
import org.cryptomator.cryptofs.CryptoFileSystems;
import org.cryptomator.cryptofs.CryptoFileSystems_Factory;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathFactory;
import org.cryptomator.cryptofs.CryptoPathFactory_Factory;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.CryptoPathMapper_Factory;
import org.cryptomator.cryptofs.DirectoryIdBackup;
import org.cryptomator.cryptofs.DirectoryIdBackup_Factory;
import org.cryptomator.cryptofs.DirectoryIdLoader;
import org.cryptomator.cryptofs.DirectoryIdLoader_Factory;
import org.cryptomator.cryptofs.DirectoryIdProvider;
import org.cryptomator.cryptofs.DirectoryIdProvider_Factory;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.GlobToRegexConverter;
import org.cryptomator.cryptofs.GlobToRegexConverter_Factory;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.LongFileNameProvider_Factory;
import org.cryptomator.cryptofs.MoveOperation;
import org.cryptomator.cryptofs.MoveOperation_Factory;
import org.cryptomator.cryptofs.PathMatcherFactory;
import org.cryptomator.cryptofs.PathMatcherFactory_Factory;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.ReadonlyFlag_Factory;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.Symlinks_Factory;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.attr.AttributeByNameProvider;
import org.cryptomator.cryptofs.attr.AttributeByNameProvider_Factory;
import org.cryptomator.cryptofs.attr.AttributeComponent;
import org.cryptomator.cryptofs.attr.AttributeModule_ProvideAttributesFactory;
import org.cryptomator.cryptofs.attr.AttributeModule_ProvideOpenCryptoFileFactory;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeProvider_Factory;
import org.cryptomator.cryptofs.attr.AttributeViewComponent;
import org.cryptomator.cryptofs.attr.AttributeViewModule_ProvideAttributeViewFactory;
import org.cryptomator.cryptofs.attr.AttributeViewProvider;
import org.cryptomator.cryptofs.attr.AttributeViewProvider_Factory;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoDosFileAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoFileOwnerAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoPosixFileAttributeView_Factory;
import org.cryptomator.cryptofs.ch.ChannelCloseListener;
import org.cryptomator.cryptofs.ch.ChannelComponent;
import org.cryptomator.cryptofs.ch.CleartextFileChannel;
import org.cryptomator.cryptofs.ch.CleartextFileChannel_Factory;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker_Factory;
import org.cryptomator.cryptofs.common.FinallyUtil;
import org.cryptomator.cryptofs.common.FinallyUtil_Factory;
import org.cryptomator.cryptofs.dir.BrokenDirectoryFilter;
import org.cryptomator.cryptofs.dir.BrokenDirectoryFilter_Factory;
import org.cryptomator.cryptofs.dir.C9rConflictResolver;
import org.cryptomator.cryptofs.dir.C9rConflictResolver_Factory;
import org.cryptomator.cryptofs.dir.C9rDecryptor;
import org.cryptomator.cryptofs.dir.C9rDecryptor_Factory;
import org.cryptomator.cryptofs.dir.C9rProcessor;
import org.cryptomator.cryptofs.dir.C9rProcessor_Factory;
import org.cryptomator.cryptofs.dir.C9sInflator;
import org.cryptomator.cryptofs.dir.C9sInflator_Factory;
import org.cryptomator.cryptofs.dir.C9sProcessor;
import org.cryptomator.cryptofs.dir.C9sProcessor_Factory;
import org.cryptomator.cryptofs.dir.CiphertextDirectoryDeleter;
import org.cryptomator.cryptofs.dir.CiphertextDirectoryDeleter_Factory;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream_Factory;
import org.cryptomator.cryptofs.dir.DirectoryStreamComponent;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory_Factory;
import org.cryptomator.cryptofs.dir.NodeProcessor;
import org.cryptomator.cryptofs.dir.NodeProcessor_Factory;
import org.cryptomator.cryptofs.fh.BufferPool;
import org.cryptomator.cryptofs.fh.BufferPool_Factory;
import org.cryptomator.cryptofs.fh.ChunkCache;
import org.cryptomator.cryptofs.fh.ChunkCache_Factory;
import org.cryptomator.cryptofs.fh.ChunkIO;
import org.cryptomator.cryptofs.fh.ChunkIO_Factory;
import org.cryptomator.cryptofs.fh.ChunkLoader;
import org.cryptomator.cryptofs.fh.ChunkLoader_Factory;
import org.cryptomator.cryptofs.fh.ChunkSaver;
import org.cryptomator.cryptofs.fh.ChunkSaver_Factory;
import org.cryptomator.cryptofs.fh.ExceptionsDuringWrite;
import org.cryptomator.cryptofs.fh.ExceptionsDuringWrite_Factory;
import org.cryptomator.cryptofs.fh.FileCloseListener;
import org.cryptomator.cryptofs.fh.FileHeaderHolder;
import org.cryptomator.cryptofs.fh.FileHeaderHolder_Factory;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptofs.fh.OpenCryptoFileComponent;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideBasicFileAttributeViewSupplierFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideCurrentPathFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideFileSizeFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideLastModifiedDateFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideReadWriteLockFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFile_Factory;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles_Factory;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

@DaggerGenerated
final class DaggerCryptoFileSystemProviderComponent {
    private DaggerCryptoFileSystemProviderComponent() {
    }

    public static CryptoFileSystemProviderComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements CryptoFileSystemProviderComponent.Builder {
        private SecureRandom csprng;

        private Builder() {
        }

        @Override
        public Builder csprng(SecureRandom csprng) {
            this.csprng = (SecureRandom)Preconditions.checkNotNull((Object)csprng);
            return this;
        }

        @Override
        public CryptoFileSystemProviderComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.csprng, SecureRandom.class);
            return new CryptoFileSystemProviderComponentImpl(this.csprng);
        }
    }

    private static final class CryptoFileSystemProviderComponentImpl
    implements CryptoFileSystemProviderComponent {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl = this;
        private Provider<CryptoFileSystemComponent.Factory> cryptoFileSystemComponentFactoryProvider;
        private Provider<FileSystemCapabilityChecker> fileSystemCapabilityCheckerProvider;
        private Provider<SecureRandom> csprngProvider;
        private Provider<CryptoFileSystems> cryptoFileSystemsProvider;
        private Provider<CopyOperation> copyOperationProvider;
        private Provider<MoveOperation> moveOperationProvider;
        private Provider<GlobToRegexConverter> globToRegexConverterProvider;
        private Provider<PathMatcherFactory> pathMatcherFactoryProvider;
        private Provider<FinallyUtil> finallyUtilProvider;

        private CryptoFileSystemProviderComponentImpl(SecureRandom csprngParam) {
            this.initialize(csprngParam);
        }

        private void initialize(SecureRandom csprngParam) {
            this.cryptoFileSystemComponentFactoryProvider = new Provider<CryptoFileSystemComponent.Factory>(){

                public CryptoFileSystemComponent.Factory get() {
                    return new CryptoFileSystemComponentFactory(cryptoFileSystemProviderComponentImpl);
                }
            };
            this.fileSystemCapabilityCheckerProvider = DoubleCheck.provider((Provider)FileSystemCapabilityChecker_Factory.create());
            this.csprngProvider = InstanceFactory.create((Object)csprngParam);
            this.cryptoFileSystemsProvider = DoubleCheck.provider((Provider)CryptoFileSystems_Factory.create(this.cryptoFileSystemComponentFactoryProvider, this.fileSystemCapabilityCheckerProvider, this.csprngProvider));
            this.copyOperationProvider = DoubleCheck.provider((Provider)CopyOperation_Factory.create());
            this.moveOperationProvider = DoubleCheck.provider((Provider)MoveOperation_Factory.create(this.copyOperationProvider));
            this.globToRegexConverterProvider = DoubleCheck.provider((Provider)GlobToRegexConverter_Factory.create());
            this.pathMatcherFactoryProvider = DoubleCheck.provider((Provider)PathMatcherFactory_Factory.create(this.globToRegexConverterProvider));
            this.finallyUtilProvider = DoubleCheck.provider((Provider)FinallyUtil_Factory.create());
        }

        @Override
        public CryptoFileSystems fileSystems() {
            return (CryptoFileSystems)this.cryptoFileSystemsProvider.get();
        }

        @Override
        public MoveOperation moveOperation() {
            return (MoveOperation)this.moveOperationProvider.get();
        }

        @Override
        public CopyOperation copyOperation() {
            return (CopyOperation)this.copyOperationProvider.get();
        }
    }

    private static final class CryptoFileSystemComponentImpl
    implements CryptoFileSystemComponent {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl = this;
        private Provider<CryptoFileSystemProvider> providerProvider;
        private Provider<Path> pathToVaultProvider;
        private Provider<Cryptor> cryptorProvider;
        private Provider<Optional<FileStore>> provideNativeFileStoreProvider;
        private Provider<CryptoFileSystemProperties> cryptoFileSystemPropertiesProvider;
        private Provider<ReadonlyFlag> readonlyFlagProvider;
        private Provider<CryptoFileStore> cryptoFileStoreProvider;
        private Provider<CryptoFileSystemStats> cryptoFileSystemStatsProvider;
        private Provider<DirectoryIdLoader> directoryIdLoaderProvider;
        private Provider<DirectoryIdProvider> directoryIdProvider;
        private Provider<LongFileNameProvider> longFileNameProvider;
        private Provider<VaultConfig> vaultConfigProvider;
        private Provider<CryptoPathMapper> cryptoPathMapperProvider;
        private Provider<OpenCryptoFileComponent.Factory> openCryptoFileComponentFactoryProvider;
        private Provider<OpenCryptoFiles> openCryptoFilesProvider;
        private Provider<Symlinks> symlinksProvider;
        private Provider<CryptoPathFactory> cryptoPathFactoryProvider;
        private Provider<DirectoryStreamComponent.Factory> directoryStreamComponentFactoryProvider;
        private Provider<DirectoryStreamFactory> directoryStreamFactoryProvider;
        private Provider<DirectoryIdBackup> directoryIdBackupProvider;
        private Provider<AttributeComponent.Factory> attributeComponentFactoryProvider;
        private Provider<AttributeProvider> attributeProvider;
        private Provider<AttributeViewComponent.Factory> attributeViewComponentFactoryProvider;
        private Provider<AttributeViewProvider> attributeViewProvider;
        private Provider<AttributeByNameProvider> attributeByNameProvider;
        private Provider<CiphertextDirectoryDeleter> ciphertextDirectoryDeleterProvider;
        private Provider<CryptoFileSystemImpl> cryptoFileSystemImplProvider;
        private Provider<BufferPool> bufferPoolProvider;

        private CryptoFileSystemComponentImpl(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemModule cryptoFileSystemModuleParam, Cryptor cryptorParam, VaultConfig vaultConfigParam, CryptoFileSystemProvider providerParam, Path pathToVaultParam, CryptoFileSystemProperties cryptoFileSystemPropertiesParam) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.initialize(cryptoFileSystemModuleParam, cryptorParam, vaultConfigParam, providerParam, pathToVaultParam, cryptoFileSystemPropertiesParam);
        }

        private void initialize(CryptoFileSystemModule cryptoFileSystemModuleParam, Cryptor cryptorParam, VaultConfig vaultConfigParam, CryptoFileSystemProvider providerParam, Path pathToVaultParam, CryptoFileSystemProperties cryptoFileSystemPropertiesParam) {
            this.providerProvider = InstanceFactory.create((Object)providerParam);
            this.pathToVaultProvider = InstanceFactory.create((Object)pathToVaultParam);
            this.cryptorProvider = InstanceFactory.create((Object)cryptorParam);
            this.provideNativeFileStoreProvider = DoubleCheck.provider((Provider)CryptoFileSystemModule_ProvideNativeFileStoreFactory.create(cryptoFileSystemModuleParam, this.pathToVaultProvider));
            this.cryptoFileSystemPropertiesProvider = InstanceFactory.create((Object)cryptoFileSystemPropertiesParam);
            this.readonlyFlagProvider = DoubleCheck.provider((Provider)ReadonlyFlag_Factory.create(this.cryptoFileSystemPropertiesProvider));
            this.cryptoFileStoreProvider = DoubleCheck.provider((Provider)CryptoFileStore_Factory.create(this.provideNativeFileStoreProvider, this.readonlyFlagProvider));
            this.cryptoFileSystemStatsProvider = DoubleCheck.provider((Provider)CryptoFileSystemStats_Factory.create());
            this.directoryIdLoaderProvider = DoubleCheck.provider((Provider)DirectoryIdLoader_Factory.create());
            this.directoryIdProvider = DoubleCheck.provider((Provider)DirectoryIdProvider_Factory.create(this.directoryIdLoaderProvider));
            this.longFileNameProvider = DoubleCheck.provider((Provider)LongFileNameProvider_Factory.create(this.readonlyFlagProvider));
            this.vaultConfigProvider = InstanceFactory.create((Object)vaultConfigParam);
            this.cryptoPathMapperProvider = DoubleCheck.provider((Provider)CryptoPathMapper_Factory.create(this.pathToVaultProvider, this.cryptorProvider, this.directoryIdProvider, this.longFileNameProvider, this.vaultConfigProvider));
            this.openCryptoFileComponentFactoryProvider = new Provider<OpenCryptoFileComponent.Factory>(){

                public OpenCryptoFileComponent.Factory get() {
                    return new OpenCryptoFileComponentFactory(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl);
                }
            };
            this.openCryptoFilesProvider = DoubleCheck.provider((Provider)OpenCryptoFiles_Factory.create(this.openCryptoFileComponentFactoryProvider));
            this.symlinksProvider = DoubleCheck.provider((Provider)Symlinks_Factory.create(this.cryptoPathMapperProvider, this.longFileNameProvider, this.openCryptoFilesProvider, this.readonlyFlagProvider));
            this.cryptoPathFactoryProvider = DoubleCheck.provider((Provider)CryptoPathFactory_Factory.create(this.symlinksProvider));
            this.directoryStreamComponentFactoryProvider = new Provider<DirectoryStreamComponent.Factory>(){

                public DirectoryStreamComponent.Factory get() {
                    return new DirectoryStreamComponentFactory(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl);
                }
            };
            this.directoryStreamFactoryProvider = DoubleCheck.provider((Provider)DirectoryStreamFactory_Factory.create(this.cryptoPathMapperProvider, this.directoryStreamComponentFactoryProvider));
            this.directoryIdBackupProvider = DoubleCheck.provider((Provider)DirectoryIdBackup_Factory.create(this.cryptorProvider));
            this.attributeComponentFactoryProvider = new Provider<AttributeComponent.Factory>(){

                public AttributeComponent.Factory get() {
                    return new AttributeComponentFactory(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl);
                }
            };
            this.attributeProvider = DoubleCheck.provider((Provider)AttributeProvider_Factory.create(this.attributeComponentFactoryProvider, this.cryptoPathMapperProvider, this.symlinksProvider));
            this.attributeViewComponentFactoryProvider = new Provider<AttributeViewComponent.Factory>(){

                public AttributeViewComponent.Factory get() {
                    return new AttributeViewComponentFactory(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl);
                }
            };
            this.attributeViewProvider = DoubleCheck.provider((Provider)AttributeViewProvider_Factory.create(this.attributeViewComponentFactoryProvider));
            this.attributeByNameProvider = DoubleCheck.provider((Provider)AttributeByNameProvider_Factory.create(this.attributeProvider, this.attributeViewProvider));
            this.ciphertextDirectoryDeleterProvider = DoubleCheck.provider((Provider)CiphertextDirectoryDeleter_Factory.create(this.directoryStreamFactoryProvider));
            this.cryptoFileSystemImplProvider = DoubleCheck.provider((Provider)CryptoFileSystemImpl_Factory.create(this.providerProvider, this.cryptoFileSystemProviderComponentImpl.cryptoFileSystemsProvider, this.pathToVaultProvider, this.cryptorProvider, this.cryptoFileStoreProvider, this.cryptoFileSystemStatsProvider, this.cryptoPathMapperProvider, this.cryptoPathFactoryProvider, this.cryptoFileSystemProviderComponentImpl.pathMatcherFactoryProvider, this.directoryStreamFactoryProvider, this.directoryIdProvider, this.directoryIdBackupProvider, this.attributeProvider, this.attributeByNameProvider, this.attributeViewProvider, this.openCryptoFilesProvider, this.symlinksProvider, this.cryptoFileSystemProviderComponentImpl.finallyUtilProvider, this.ciphertextDirectoryDeleterProvider, this.readonlyFlagProvider, this.cryptoFileSystemPropertiesProvider));
            this.bufferPoolProvider = DoubleCheck.provider((Provider)BufferPool_Factory.create(this.cryptorProvider));
        }

        @Override
        public CryptoFileSystemImpl cryptoFileSystem() {
            return (CryptoFileSystemImpl)this.cryptoFileSystemImplProvider.get();
        }
    }

    private static final class AttributeViewComponentImpl
    implements AttributeViewComponent {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
        private final AttributeViewComponentImpl attributeViewComponentImpl = this;
        private Provider<CryptoPath> cleartextPathProvider;
        private Provider<LinkOption[]> linkOptionsProvider;
        private Provider cryptoBasicFileAttributeViewProvider;
        private Provider cryptoPosixFileAttributeViewProvider;
        private Provider cryptoDosFileAttributeViewProvider;
        private Provider cryptoFileOwnerAttributeViewProvider;
        private Provider<Map<Class<?>, Provider<FileAttributeView>>> mapOfClassOfAndProviderOfFileAttributeViewProvider;
        private Provider<Class<? extends FileAttributeView>> typeProvider;
        private Provider<Optional<FileAttributeView>> provideAttributeViewProvider;

        private AttributeViewComponentImpl(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, CryptoPath cleartextPathParam, Class<? extends FileAttributeView> typeParam, LinkOption[] linkOptionsParam) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            this.initialize(cleartextPathParam, typeParam, linkOptionsParam);
        }

        private void initialize(CryptoPath cleartextPathParam, Class<? extends FileAttributeView> typeParam, LinkOption[] linkOptionsParam) {
            this.cleartextPathProvider = InstanceFactory.create((Object)cleartextPathParam);
            this.linkOptionsProvider = InstanceFactory.create((Object)linkOptionsParam);
            this.cryptoBasicFileAttributeViewProvider = DoubleCheck.provider((Provider)CryptoBasicFileAttributeView_Factory.create(this.cleartextPathProvider, this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider, this.linkOptionsProvider, this.cryptoFileSystemComponentImpl.symlinksProvider, this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.cryptoFileSystemComponentImpl.attributeProvider, this.cryptoFileSystemComponentImpl.readonlyFlagProvider));
            this.cryptoPosixFileAttributeViewProvider = DoubleCheck.provider((Provider)CryptoPosixFileAttributeView_Factory.create(this.cleartextPathProvider, this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider, this.linkOptionsProvider, this.cryptoFileSystemComponentImpl.symlinksProvider, this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.cryptoFileSystemComponentImpl.attributeProvider, this.cryptoFileSystemComponentImpl.readonlyFlagProvider));
            this.cryptoDosFileAttributeViewProvider = DoubleCheck.provider((Provider)CryptoDosFileAttributeView_Factory.create(this.cleartextPathProvider, this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider, this.linkOptionsProvider, this.cryptoFileSystemComponentImpl.symlinksProvider, this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.cryptoFileSystemComponentImpl.attributeProvider, this.cryptoFileSystemComponentImpl.readonlyFlagProvider));
            this.cryptoFileOwnerAttributeViewProvider = DoubleCheck.provider((Provider)CryptoFileOwnerAttributeView_Factory.create(this.cleartextPathProvider, this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider, this.linkOptionsProvider, this.cryptoFileSystemComponentImpl.symlinksProvider, this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.cryptoFileSystemComponentImpl.readonlyFlagProvider));
            this.mapOfClassOfAndProviderOfFileAttributeViewProvider = MapProviderFactory.builder((int)4).put(BasicFileAttributeView.class, this.cryptoBasicFileAttributeViewProvider).put(PosixFileAttributeView.class, this.cryptoPosixFileAttributeViewProvider).put(DosFileAttributeView.class, this.cryptoDosFileAttributeViewProvider).put(FileOwnerAttributeView.class, this.cryptoFileOwnerAttributeViewProvider).build();
            this.typeProvider = InstanceFactory.create(typeParam);
            this.provideAttributeViewProvider = DoubleCheck.provider((Provider)AttributeViewModule_ProvideAttributeViewFactory.create(this.mapOfClassOfAndProviderOfFileAttributeViewProvider, this.typeProvider));
        }

        @Override
        public Optional<FileAttributeView> attributeView() {
            return (Optional)this.provideAttributeViewProvider.get();
        }
    }

    private static final class AttributeComponentImpl
    implements AttributeComponent {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
        private final AttributeComponentImpl attributeComponentImpl = this;
        private Provider<BasicFileAttributes> ciphertextAttributesProvider;
        private Provider<CiphertextFileType> ciphertextFileTypeProvider;
        private Provider<Path> ciphertextPathProvider;
        private Provider<Optional<OpenCryptoFile>> provideOpenCryptoFileProvider;
        private Provider<BasicFileAttributes> provideAttributesProvider;

        private AttributeComponentImpl(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, Path ciphertextPathParam, CiphertextFileType ciphertextFileTypeParam, BasicFileAttributes ciphertextAttributesParam) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            this.initialize(ciphertextPathParam, ciphertextFileTypeParam, ciphertextAttributesParam);
        }

        private void initialize(Path ciphertextPathParam, CiphertextFileType ciphertextFileTypeParam, BasicFileAttributes ciphertextAttributesParam) {
            this.ciphertextAttributesProvider = InstanceFactory.create((Object)ciphertextAttributesParam);
            this.ciphertextFileTypeProvider = InstanceFactory.create((Object)((Object)ciphertextFileTypeParam));
            this.ciphertextPathProvider = InstanceFactory.create((Object)ciphertextPathParam);
            this.provideOpenCryptoFileProvider = DoubleCheck.provider((Provider)AttributeModule_ProvideOpenCryptoFileFactory.create(this.cryptoFileSystemComponentImpl.openCryptoFilesProvider, this.ciphertextPathProvider));
            this.provideAttributesProvider = DoubleCheck.provider((Provider)AttributeModule_ProvideAttributesFactory.create(this.ciphertextAttributesProvider, this.ciphertextFileTypeProvider, this.ciphertextPathProvider, this.cryptoFileSystemComponentImpl.cryptorProvider, this.provideOpenCryptoFileProvider, this.cryptoFileSystemComponentImpl.cryptoFileSystemPropertiesProvider));
        }

        @Override
        public BasicFileAttributes attributes() {
            return (BasicFileAttributes)this.provideAttributesProvider.get();
        }
    }

    private static final class DirectoryStreamComponentImpl
    implements DirectoryStreamComponent {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
        private final DirectoryStreamComponentImpl directoryStreamComponentImpl = this;
        private Provider<String> dirIdProvider;
        private Provider<DirectoryStream<Path>> ciphertextDirectoryStreamProvider;
        private Provider<Path> cleartextPathProvider;
        private Provider<DirectoryStream.Filter<? super Path>> filterProvider;
        private Provider<Consumer<CryptoDirectoryStream>> onCloseProvider;
        private Provider c9rDecryptorProvider;
        private Provider c9rConflictResolverProvider;
        private Provider c9rProcessorProvider;
        private Provider c9sInflatorProvider;
        private Provider c9sProcessorProvider;
        private Provider brokenDirectoryFilterProvider;
        private Provider nodeProcessorProvider;
        private Provider<CryptoDirectoryStream> cryptoDirectoryStreamProvider;

        private DirectoryStreamComponentImpl(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, Path cleartextPathParam, String dirIdParam, DirectoryStream<Path> ciphertextDirectoryStreamParam, DirectoryStream.Filter<? super Path> filterParam, Consumer<CryptoDirectoryStream> onCloseParam) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            this.initialize(cleartextPathParam, dirIdParam, ciphertextDirectoryStreamParam, filterParam, onCloseParam);
        }

        private void initialize(Path cleartextPathParam, String dirIdParam, DirectoryStream<Path> ciphertextDirectoryStreamParam, DirectoryStream.Filter<? super Path> filterParam, Consumer<CryptoDirectoryStream> onCloseParam) {
            this.dirIdProvider = InstanceFactory.create((Object)dirIdParam);
            this.ciphertextDirectoryStreamProvider = InstanceFactory.create(ciphertextDirectoryStreamParam);
            this.cleartextPathProvider = InstanceFactory.create((Object)cleartextPathParam);
            this.filterProvider = InstanceFactory.create(filterParam);
            this.onCloseProvider = InstanceFactory.create(onCloseParam);
            this.c9rDecryptorProvider = DoubleCheck.provider((Provider)C9rDecryptor_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, this.dirIdProvider));
            this.c9rConflictResolverProvider = DoubleCheck.provider((Provider)C9rConflictResolver_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, this.dirIdProvider, this.cryptoFileSystemComponentImpl.vaultConfigProvider));
            this.c9rProcessorProvider = DoubleCheck.provider((Provider)C9rProcessor_Factory.create((Provider<C9rDecryptor>)this.c9rDecryptorProvider, (Provider<C9rConflictResolver>)this.c9rConflictResolverProvider));
            this.c9sInflatorProvider = DoubleCheck.provider((Provider)C9sInflator_Factory.create(this.cryptoFileSystemComponentImpl.longFileNameProvider, this.cryptoFileSystemComponentImpl.cryptorProvider, this.dirIdProvider));
            this.c9sProcessorProvider = DoubleCheck.provider((Provider)C9sProcessor_Factory.create((Provider<C9sInflator>)this.c9sInflatorProvider));
            this.brokenDirectoryFilterProvider = DoubleCheck.provider((Provider)BrokenDirectoryFilter_Factory.create(this.cryptoFileSystemComponentImpl.cryptoPathMapperProvider));
            this.nodeProcessorProvider = DoubleCheck.provider((Provider)NodeProcessor_Factory.create((Provider<C9rProcessor>)this.c9rProcessorProvider, (Provider<C9sProcessor>)this.c9sProcessorProvider, (Provider<BrokenDirectoryFilter>)this.brokenDirectoryFilterProvider));
            this.cryptoDirectoryStreamProvider = DoubleCheck.provider((Provider)CryptoDirectoryStream_Factory.create(this.dirIdProvider, this.ciphertextDirectoryStreamProvider, this.cleartextPathProvider, this.filterProvider, this.onCloseProvider, (Provider<NodeProcessor>)this.nodeProcessorProvider));
        }

        @Override
        public CryptoDirectoryStream directoryStream() {
            return (CryptoDirectoryStream)this.cryptoDirectoryStreamProvider.get();
        }
    }

    private static final class OpenCryptoFileComponentImpl
    implements OpenCryptoFileComponent {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
        private final OpenCryptoFileComponentImpl openCryptoFileComponentImpl = this;
        private Provider<FileCloseListener> onCloseListenerProvider;
        private Provider chunkIOProvider;
        private Provider<Path> pathProvider;
        private Provider<AtomicReference<Path>> provideCurrentPathProvider;
        private Provider<FileHeaderHolder> fileHeaderHolderProvider;
        private Provider chunkLoaderProvider;
        private Provider<ExceptionsDuringWrite> exceptionsDuringWriteProvider;
        private Provider chunkSaverProvider;
        private Provider<ChunkCache> chunkCacheProvider;
        private Provider<AtomicLong> provideFileSizeProvider;
        private Provider<AtomicReference<Instant>> provideLastModifiedDateProvider;
        private Provider<OpenCryptoFileComponent> openCryptoFileComponentProvider;
        private Provider<OpenCryptoFile> openCryptoFileProvider;
        private Provider<ReadWriteLock> provideReadWriteLockProvider;
        private Provider<Supplier<BasicFileAttributeView>> provideBasicFileAttributeViewSupplierProvider;

        private OpenCryptoFileComponentImpl(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, OpenCryptoFileModule openCryptoFileModuleParam, Path pathParam, FileCloseListener onCloseListenerParam) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            this.initialize(openCryptoFileModuleParam, pathParam, onCloseListenerParam);
        }

        private void initialize(OpenCryptoFileModule openCryptoFileModuleParam, Path pathParam, FileCloseListener onCloseListenerParam) {
            this.onCloseListenerProvider = InstanceFactory.create((Object)onCloseListenerParam);
            this.chunkIOProvider = DoubleCheck.provider((Provider)ChunkIO_Factory.create());
            this.pathProvider = InstanceFactory.create((Object)pathParam);
            this.provideCurrentPathProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideCurrentPathFactory.create(openCryptoFileModuleParam, this.pathProvider));
            this.fileHeaderHolderProvider = DoubleCheck.provider((Provider)FileHeaderHolder_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, this.provideCurrentPathProvider));
            this.chunkLoaderProvider = DoubleCheck.provider((Provider)ChunkLoader_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, (Provider<ChunkIO>)this.chunkIOProvider, this.fileHeaderHolderProvider, this.cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider, this.cryptoFileSystemComponentImpl.bufferPoolProvider));
            this.exceptionsDuringWriteProvider = DoubleCheck.provider((Provider)ExceptionsDuringWrite_Factory.create());
            this.chunkSaverProvider = DoubleCheck.provider((Provider)ChunkSaver_Factory.create(this.cryptoFileSystemComponentImpl.cryptorProvider, (Provider<ChunkIO>)this.chunkIOProvider, this.fileHeaderHolderProvider, this.exceptionsDuringWriteProvider, this.cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider, this.cryptoFileSystemComponentImpl.bufferPoolProvider));
            this.chunkCacheProvider = DoubleCheck.provider((Provider)ChunkCache_Factory.create((Provider<ChunkLoader>)this.chunkLoaderProvider, (Provider<ChunkSaver>)this.chunkSaverProvider, this.cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider, this.cryptoFileSystemComponentImpl.bufferPoolProvider));
            this.provideFileSizeProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideFileSizeFactory.create(openCryptoFileModuleParam));
            this.provideLastModifiedDateProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideLastModifiedDateFactory.create(openCryptoFileModuleParam, this.pathProvider));
            this.openCryptoFileComponentProvider = InstanceFactory.create((Object)this.openCryptoFileComponentImpl);
            this.openCryptoFileProvider = DoubleCheck.provider((Provider)OpenCryptoFile_Factory.create(this.onCloseListenerProvider, this.chunkCacheProvider, this.cryptoFileSystemComponentImpl.cryptorProvider, this.fileHeaderHolderProvider, (Provider<ChunkIO>)this.chunkIOProvider, this.provideCurrentPathProvider, this.provideFileSizeProvider, this.provideLastModifiedDateProvider, this.openCryptoFileComponentProvider));
            this.provideReadWriteLockProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideReadWriteLockFactory.create(openCryptoFileModuleParam));
            this.provideBasicFileAttributeViewSupplierProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideBasicFileAttributeViewSupplierFactory.create(openCryptoFileModuleParam, this.provideCurrentPathProvider));
        }

        @Override
        public OpenCryptoFile openCryptoFile() {
            return (OpenCryptoFile)this.openCryptoFileProvider.get();
        }

        @Override
        public ChannelComponent.Factory newChannelComponent() {
            return new ChannelComponentFactory(this.cryptoFileSystemProviderComponentImpl, this.cryptoFileSystemComponentImpl, this.openCryptoFileComponentImpl);
        }
    }

    private static final class ChannelComponentImpl
    implements ChannelComponent {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
        private final OpenCryptoFileComponentImpl openCryptoFileComponentImpl;
        private final ChannelComponentImpl channelComponentImpl = this;
        private Provider<FileChannel> ciphertextChannelProvider;
        private Provider<FileHeader> fileHeaderProvider;
        private Provider<Boolean> mustWriteHeaderProvider;
        private Provider<EffectiveOpenOptions> optionsProvider;
        private Provider<ChannelCloseListener> listenerProvider;
        private Provider<CleartextFileChannel> cleartextFileChannelProvider;

        private ChannelComponentImpl(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, OpenCryptoFileComponentImpl openCryptoFileComponentImpl, FileChannel ciphertextChannelParam, FileHeader fileHeaderParam, Boolean mustWriteHeaderParam, EffectiveOpenOptions optionsParam, ChannelCloseListener listenerParam) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            this.openCryptoFileComponentImpl = openCryptoFileComponentImpl;
            this.initialize(ciphertextChannelParam, fileHeaderParam, mustWriteHeaderParam, optionsParam, listenerParam);
        }

        private void initialize(FileChannel ciphertextChannelParam, FileHeader fileHeaderParam, Boolean mustWriteHeaderParam, EffectiveOpenOptions optionsParam, ChannelCloseListener listenerParam) {
            this.ciphertextChannelProvider = InstanceFactory.create((Object)ciphertextChannelParam);
            this.fileHeaderProvider = InstanceFactory.create((Object)fileHeaderParam);
            this.mustWriteHeaderProvider = InstanceFactory.create((Object)mustWriteHeaderParam);
            this.optionsProvider = InstanceFactory.create((Object)optionsParam);
            this.listenerProvider = InstanceFactory.create((Object)listenerParam);
            this.cleartextFileChannelProvider = DoubleCheck.provider((Provider)CleartextFileChannel_Factory.create(this.ciphertextChannelProvider, this.fileHeaderProvider, this.mustWriteHeaderProvider, this.openCryptoFileComponentImpl.provideReadWriteLockProvider, this.cryptoFileSystemComponentImpl.cryptorProvider, this.openCryptoFileComponentImpl.chunkCacheProvider, this.cryptoFileSystemComponentImpl.bufferPoolProvider, this.optionsProvider, this.openCryptoFileComponentImpl.provideFileSizeProvider, this.openCryptoFileComponentImpl.provideLastModifiedDateProvider, this.openCryptoFileComponentImpl.provideBasicFileAttributeViewSupplierProvider, this.openCryptoFileComponentImpl.exceptionsDuringWriteProvider, this.listenerProvider, this.cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider));
        }

        @Override
        public CleartextFileChannel channel() {
            return (CleartextFileChannel)this.cleartextFileChannelProvider.get();
        }
    }

    private static final class AttributeViewComponentFactory
    implements AttributeViewComponent.Factory {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

        private AttributeViewComponentFactory(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
        }

        @Override
        public AttributeViewComponent create(CryptoPath cleartextPath, Class<? extends FileAttributeView> type, LinkOption[] linkOptions) {
            Preconditions.checkNotNull((Object)cleartextPath);
            Preconditions.checkNotNull(type);
            Preconditions.checkNotNull((Object)linkOptions);
            return new AttributeViewComponentImpl(this.cryptoFileSystemProviderComponentImpl, this.cryptoFileSystemComponentImpl, cleartextPath, type, linkOptions);
        }
    }

    private static final class AttributeComponentFactory
    implements AttributeComponent.Factory {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

        private AttributeComponentFactory(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
        }

        @Override
        public AttributeComponent create(Path ciphertextPath, CiphertextFileType ciphertextFileType, BasicFileAttributes ciphertextAttributes) {
            Preconditions.checkNotNull((Object)ciphertextPath);
            Preconditions.checkNotNull((Object)((Object)ciphertextFileType));
            Preconditions.checkNotNull((Object)ciphertextAttributes);
            return new AttributeComponentImpl(this.cryptoFileSystemProviderComponentImpl, this.cryptoFileSystemComponentImpl, ciphertextPath, ciphertextFileType, ciphertextAttributes);
        }
    }

    private static final class DirectoryStreamComponentFactory
    implements DirectoryStreamComponent.Factory {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

        private DirectoryStreamComponentFactory(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
        }

        @Override
        public DirectoryStreamComponent create(Path cleartextPath, String dirId, DirectoryStream<Path> ciphertextDirectoryStream, DirectoryStream.Filter<? super Path> filter, Consumer<CryptoDirectoryStream> onClose) {
            Preconditions.checkNotNull((Object)cleartextPath);
            Preconditions.checkNotNull((Object)dirId);
            Preconditions.checkNotNull(ciphertextDirectoryStream);
            Preconditions.checkNotNull(filter);
            Preconditions.checkNotNull(onClose);
            return new DirectoryStreamComponentImpl(this.cryptoFileSystemProviderComponentImpl, this.cryptoFileSystemComponentImpl, cleartextPath, dirId, ciphertextDirectoryStream, filter, onClose);
        }
    }

    private static final class ChannelComponentFactory
    implements ChannelComponent.Factory {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;
        private final OpenCryptoFileComponentImpl openCryptoFileComponentImpl;

        private ChannelComponentFactory(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, OpenCryptoFileComponentImpl openCryptoFileComponentImpl) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
            this.openCryptoFileComponentImpl = openCryptoFileComponentImpl;
        }

        @Override
        public ChannelComponent create(FileChannel ciphertextChannel, FileHeader fileHeader, boolean mustWriteHeader, EffectiveOpenOptions options, ChannelCloseListener listener) {
            Preconditions.checkNotNull((Object)ciphertextChannel);
            Preconditions.checkNotNull((Object)fileHeader);
            Preconditions.checkNotNull((Object)mustWriteHeader);
            Preconditions.checkNotNull((Object)options);
            Preconditions.checkNotNull((Object)listener);
            return new ChannelComponentImpl(this.cryptoFileSystemProviderComponentImpl, this.cryptoFileSystemComponentImpl, this.openCryptoFileComponentImpl, ciphertextChannel, fileHeader, mustWriteHeader, options, listener);
        }
    }

    private static final class OpenCryptoFileComponentFactory
    implements OpenCryptoFileComponent.Factory {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;
        private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

        private OpenCryptoFileComponentFactory(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl, CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
            this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
        }

        @Override
        public OpenCryptoFileComponent create(Path path, FileCloseListener onCloseListener) {
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkNotNull((Object)onCloseListener);
            return new OpenCryptoFileComponentImpl(this.cryptoFileSystemProviderComponentImpl, this.cryptoFileSystemComponentImpl, new OpenCryptoFileModule(), path, onCloseListener);
        }
    }

    private static final class CryptoFileSystemComponentFactory
    implements CryptoFileSystemComponent.Factory {
        private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

        private CryptoFileSystemComponentFactory(CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl) {
            this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
        }

        @Override
        public CryptoFileSystemComponent create(Cryptor cryptor, VaultConfig vaultConfig, CryptoFileSystemProvider provider, Path pathToVault, CryptoFileSystemProperties cryptoFileSystemProperties) {
            Preconditions.checkNotNull((Object)cryptor);
            Preconditions.checkNotNull((Object)vaultConfig);
            Preconditions.checkNotNull((Object)provider);
            Preconditions.checkNotNull((Object)pathToVault);
            Preconditions.checkNotNull((Object)cryptoFileSystemProperties);
            return new CryptoFileSystemComponentImpl(this.cryptoFileSystemProviderComponentImpl, new CryptoFileSystemModule(), cryptor, vaultConfig, provider, pathToVault, cryptoFileSystemProperties);
        }
    }
}

