/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import java.io.Closeable;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Provider;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptofs.fh.OpenCryptoFileComponent;

@CryptoFileSystemScoped
public class OpenCryptoFiles
implements Closeable {
    private final Provider<OpenCryptoFileComponent.Builder> openCryptoFileComponentBuilderProvider;
    private final ConcurrentMap<Path, OpenCryptoFile> openCryptoFiles = new ConcurrentHashMap<Path, OpenCryptoFile>();

    @Inject
    OpenCryptoFiles(Provider<OpenCryptoFileComponent.Builder> openCryptoFileComponentBuilderProvider) {
        this.openCryptoFileComponentBuilderProvider = openCryptoFileComponentBuilderProvider;
    }

    public Optional<OpenCryptoFile> get(Path ciphertextPath) {
        Path normalizedPath = ciphertextPath.toAbsolutePath().normalize();
        return Optional.ofNullable((OpenCryptoFile)this.openCryptoFiles.get(normalizedPath));
    }

    public OpenCryptoFile getOrCreate(Path ciphertextPath) {
        Path normalizedPath = ciphertextPath.toAbsolutePath().normalize();
        return this.openCryptoFiles.computeIfAbsent(normalizedPath, this::create);
    }

    private OpenCryptoFile create(Path normalizedPath) {
        OpenCryptoFileComponent.Builder builder = (OpenCryptoFileComponent.Builder)this.openCryptoFileComponentBuilderProvider.get();
        OpenCryptoFileComponent openCryptoFileComponent = builder.path(normalizedPath).onClose(this.openCryptoFiles::remove).build();
        return openCryptoFileComponent.openCryptoFile();
    }

    public void writeCiphertextFile(Path ciphertextPath, EffectiveOpenOptions openOptions, ByteBuffer contents) throws IOException {
        try (OpenCryptoFile f = this.getOrCreate(ciphertextPath);
             FileChannel ch = f.newFileChannel(openOptions);){
            ch.write(contents);
        }
    }

    public ByteBuffer readCiphertextFile(Path ciphertextPath, EffectiveOpenOptions openOptions, int maxBufferSize) throws BufferUnderflowException, IOException {
        try (OpenCryptoFile f = this.getOrCreate(ciphertextPath);){
            ByteBuffer byteBuffer;
            block13: {
                FileChannel ch = f.newFileChannel(openOptions);
                try {
                    if (ch.size() > (long)maxBufferSize) {
                        throw new BufferUnderflowException();
                    }
                    ByteBuffer buf = ByteBuffer.allocate((int)ch.size());
                    ch.read(buf);
                    buf.flip();
                    byteBuffer = buf;
                    if (ch == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ch.close();
            }
            return byteBuffer;
        }
    }

    public TwoPhaseMove prepareMove(Path src, Path dst) throws FileAlreadyExistsException {
        return new TwoPhaseMove(src, dst);
    }

    @Override
    public void close() {
        Iterator iter = this.openCryptoFiles.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            iter.remove();
            ((OpenCryptoFile)entry.getValue()).close();
        }
    }

    public class TwoPhaseMove
    implements AutoCloseable {
        private final Path src;
        private final Path dst;
        private final OpenCryptoFile openCryptoFile;
        private boolean committed;
        private boolean rolledBack;

        private TwoPhaseMove(Path src, Path dst) throws FileAlreadyExistsException {
            this.src = Objects.requireNonNull(src);
            this.dst = Objects.requireNonNull(dst);
            try {
                this.openCryptoFile = OpenCryptoFiles.this.openCryptoFiles.compute(dst, (k, v) -> {
                    if (v == null) {
                        return (OpenCryptoFile)OpenCryptoFiles.this.openCryptoFiles.get(src);
                    }
                    throw new AlreadyMappedException();
                });
            }
            catch (AlreadyMappedException e) {
                throw new FileAlreadyExistsException(dst.toString(), null, "Destination file currently accessed by another thread.");
            }
        }

        public void commit() {
            if (this.rolledBack) {
                throw new IllegalStateException();
            }
            if (this.openCryptoFile != null) {
                this.openCryptoFile.setCurrentFilePath(this.dst);
            }
            OpenCryptoFiles.this.openCryptoFiles.remove(this.src, this.openCryptoFile);
            this.committed = true;
        }

        public void rollback() {
            if (this.committed) {
                throw new IllegalStateException();
            }
            OpenCryptoFiles.this.openCryptoFiles.remove(this.dst, this.openCryptoFile);
            this.rolledBack = true;
        }

        @Override
        public void close() {
            if (!this.committed) {
                this.rollback();
            }
        }
    }

    private static class AlreadyMappedException
    extends RuntimeException {
        private AlreadyMappedException() {
        }
    }
}

