/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.cryptomator.cryptofs.fh.CurrentOpenFilePath;
import org.cryptomator.cryptofs.fh.OpenFileModifiedDate;
import org.cryptomator.cryptofs.fh.OpenFileScoped;
import org.cryptomator.cryptofs.fh.OpenFileSize;
import org.cryptomator.cryptofs.fh.OriginalOpenFilePath;

@Module
public class OpenCryptoFileModule {
    @Provides
    @OpenFileScoped
    public ReadWriteLock provideReadWriteLock() {
        return new ReentrantReadWriteLock();
    }

    @Provides
    @OpenFileScoped
    @CurrentOpenFilePath
    public AtomicReference<Path> provideCurrentPath(@OriginalOpenFilePath Path originalPath) {
        return new AtomicReference<Path>(originalPath);
    }

    @Provides
    @OpenFileScoped
    public Supplier<BasicFileAttributeView> provideBasicFileAttributeViewSupplier(@CurrentOpenFilePath AtomicReference<Path> currentPath) {
        return () -> {
            Path path = (Path)currentPath.get();
            return path.getFileSystem().provider().getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
        };
    }

    @Provides
    @OpenFileScoped
    @OpenFileModifiedDate
    public AtomicReference<Instant> provideLastModifiedDate(@OriginalOpenFilePath Path originalPath) {
        Instant lastModifiedDate = this.readBasicAttributes(originalPath).map(BasicFileAttributes::lastModifiedTime).map(FileTime::toInstant).orElse(Instant.EPOCH);
        return new AtomicReference<Instant>(lastModifiedDate);
    }

    @Provides
    @OpenFileScoped
    @OpenFileSize
    public AtomicLong provideFileSize() {
        return new AtomicLong(-1L);
    }

    private Optional<BasicFileAttributes> readBasicAttributes(Path path) {
        try {
            return Optional.of(Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

