/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.fh.BufferPool;
import org.cryptomator.cryptofs.fh.Chunk;
import org.cryptomator.cryptofs.fh.ChunkIO;
import org.cryptomator.cryptofs.fh.FileHeaderHolder;
import org.cryptomator.cryptofs.fh.OpenFileScoped;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.Cryptor;

@OpenFileScoped
class ChunkLoader {
    private final Cryptor cryptor;
    private final ChunkIO ciphertext;
    private final FileHeaderHolder headerHolder;
    private final CryptoFileSystemStats stats;
    private final BufferPool bufferPool;

    @Inject
    public ChunkLoader(Cryptor cryptor, ChunkIO ciphertext, FileHeaderHolder headerHolder, CryptoFileSystemStats stats, BufferPool bufferPool) {
        this.cryptor = cryptor;
        this.ciphertext = ciphertext;
        this.headerHolder = headerHolder;
        this.stats = stats;
        this.bufferPool = bufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk load(Long chunkIndex) throws IOException, AuthenticationFailedException {
        this.stats.addChunkCacheMiss();
        int chunkSize = this.cryptor.fileContentCryptor().ciphertextChunkSize();
        long ciphertextPos = chunkIndex * (long)chunkSize + (long)this.cryptor.fileHeaderCryptor().headerSize();
        ByteBuffer ciphertextBuf = this.bufferPool.getCiphertextBuffer();
        ByteBuffer cleartextBuf = this.bufferPool.getCleartextBuffer();
        try {
            int read = this.ciphertext.read(ciphertextBuf, ciphertextPos);
            if (read == -1) {
                cleartextBuf.limit(0);
            } else {
                ciphertextBuf.flip();
                this.cryptor.fileContentCryptor().decryptChunk(ciphertextBuf, cleartextBuf, chunkIndex.longValue(), this.headerHolder.get(), true);
                cleartextBuf.flip();
                this.stats.addBytesDecrypted(cleartextBuf.remaining());
            }
            Chunk chunk = new Chunk(cleartextBuf, false);
            return chunk;
        }
        finally {
            this.bufferPool.recycle(ciphertextBuf);
        }
    }
}

