/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.cryptomator.cryptofs.fh.OpenFileScoped;

@OpenFileScoped
class ChunkIO {
    private final Set<FileChannel> readableChannels = ConcurrentHashMap.newKeySet();
    private final Set<FileChannel> writableChannels = ConcurrentHashMap.newKeySet();

    @Inject
    public ChunkIO() {
    }

    public void registerChannel(FileChannel channel, boolean writable) {
        this.readableChannels.add(channel);
        if (writable) {
            this.writableChannels.add(channel);
        }
    }

    public void unregisterChannel(FileChannel channel) {
        this.readableChannels.remove(channel);
        this.writableChannels.remove(channel);
    }

    int read(ByteBuffer dst, long position) throws IOException {
        return this.getReadableChannel().read(dst, position);
    }

    int write(ByteBuffer src, long position) throws IOException {
        return this.getWritableChannel().write(src, position);
    }

    private FileChannel getReadableChannel() {
        Iterator<FileChannel> iter = this.readableChannels.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        throw new NonReadableChannelException();
    }

    private FileChannel getWritableChannel() {
        Iterator<FileChannel> iter = this.writableChannels.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        throw new NonWritableChannelException();
    }
}

