/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Optional;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptolib.api.Cryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class CryptoBasicFileAttributes
implements BasicFileAttributes {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoBasicFileAttributes.class);
    private final CiphertextFileType ciphertextFileType;
    private final long size;
    private final FileTime lastModifiedTime;
    private final FileTime lastAccessTime;
    private final FileTime creationTime;
    private final Object fileKey;

    public CryptoBasicFileAttributes(BasicFileAttributes delegate, CiphertextFileType ciphertextFileType, Path ciphertextPath, Cryptor cryptor, Optional<OpenCryptoFile> openCryptoFile) {
        this.ciphertextFileType = ciphertextFileType;
        this.size = switch (ciphertextFileType) {
            default -> throw new IncompatibleClassChangeError();
            case CiphertextFileType.SYMLINK, CiphertextFileType.DIRECTORY -> delegate.size();
            case CiphertextFileType.FILE -> CryptoBasicFileAttributes.getPlaintextFileSize(ciphertextPath, delegate.size(), openCryptoFile, cryptor);
        };
        this.lastModifiedTime = openCryptoFile.map(OpenCryptoFile::getLastModifiedTime).orElseGet(delegate::lastModifiedTime);
        this.lastAccessTime = openCryptoFile.map(openFile -> FileTime.from(Instant.now())).orElseGet(delegate::lastAccessTime);
        this.creationTime = delegate.creationTime();
        this.fileKey = delegate.fileKey();
    }

    private static long getPlaintextFileSize(Path ciphertextPath, long size, Optional<OpenCryptoFile> openCryptoFile, Cryptor cryptor) {
        return openCryptoFile.flatMap(OpenCryptoFile::size).orElseGet(() -> CryptoBasicFileAttributes.calculatePlaintextFileSize(ciphertextPath, size, cryptor));
    }

    private static long calculatePlaintextFileSize(Path ciphertextPath, long size, Cryptor cryptor) {
        try {
            long payloadSize = size - (long)cryptor.fileHeaderCryptor().headerSize();
            return cryptor.fileContentCryptor().cleartextSize(payloadSize);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to calculate cleartext file size for {}. Ciphertext size (including header): {}", (Object)ciphertextPath, (Object)size);
            return 0L;
        }
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public FileTime lastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public FileTime creationTime() {
        return this.creationTime;
    }

    @Override
    public boolean isRegularFile() {
        return CiphertextFileType.FILE == this.ciphertextFileType;
    }

    @Override
    public boolean isDirectory() {
        return CiphertextFileType.DIRECTORY == this.ciphertextFileType;
    }

    @Override
    public boolean isSymbolicLink() {
        return CiphertextFileType.SYMLINK == this.ciphertextFileType;
    }

    @Override
    public boolean isOther() {
        assert (this.isRegularFile() || this.isDirectory() || this.isSymbolicLink());
        return false;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Object fileKey() {
        return this.fileKey;
    }
}

