/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;

@CryptoFileSystemScoped
class DirectoryIdLoader
extends CacheLoader<Path, String> {
    private static final int MAX_DIR_ID_LENGTH = 1000;

    @Inject
    public DirectoryIdLoader() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String load(Path dirFilePath) throws IOException {
        try (FileChannel ch = FileChannel.open(dirFilePath, StandardOpenOption.READ);){
            String string;
            block18: {
                InputStream in = Channels.newInputStream(ch);
                try {
                    long size = ch.size();
                    if (size == 0L) {
                        throw new IOException("Invalid, empty directory file: " + dirFilePath);
                    }
                    if (size > 1000L) {
                        throw new IOException("Unexpectedly large directory file: " + dirFilePath);
                    }
                    assert (size <= 1000L);
                    byte[] bytes = in.readNBytes((int)size);
                    assert ((long)bytes.length == size);
                    string = new String(bytes, StandardCharsets.UTF_8);
                    if (in == null) break block18;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return string;
        }
        catch (NoSuchFileException e) {
            return UUID.randomUUID().toString();
        }
    }
}

