/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public enum DirStructure {
    VAULT,
    MAYBE_LEGACY,
    UNRELATED;


    public static DirStructure checkDirStructure(Path pathToVault, String vaultConfigFilename, String masterkeyFilename) throws IOException {
        if (!Files.readAttributes(pathToVault, BasicFileAttributes.class, new LinkOption[0]).isDirectory()) {
            throw new NotDirectoryException(pathToVault.toString());
        }
        Path vaultConfigPath = pathToVault.resolve(vaultConfigFilename);
        Path masterkeyPath = pathToVault.resolve(masterkeyFilename);
        Path dataDirPath = pathToVault.resolve("d");
        if (Files.isDirectory(dataDirPath, new LinkOption[0])) {
            if (Files.isReadable(vaultConfigPath)) {
                return VAULT;
            }
            if (Files.isReadable(masterkeyPath)) {
                return MAYBE_LEGACY;
            }
        }
        return UNRELATED;
    }
}

