/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.type;

import java.nio.file.Path;
import java.util.Map;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;

public class KnownType
implements DiagnosticResult {
    final Path cipherDir;
    final CiphertextFileType type;

    KnownType(Path ctfDirectory, CiphertextFileType type) {
        this.cipherDir = ctfDirectory;
        this.type = type;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.GOOD;
    }

    @Override
    public String toString() {
        return String.format("Node %s with determined type %s.", new Object[]{this.cipherDir, this.type});
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Encrypted Path", this.cipherDir.toString(), "Type", this.type.name());
    }
}

