/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptolib.common.MessageDigestSupplier;

@CryptoFileSystemScoped
public class LongFileNameProvider {
    public static final int MAX_FILENAME_BUFFER_SIZE = 10240;
    private static final BaseEncoding BASE64 = BaseEncoding.base64Url();
    private static final Duration MAX_CACHE_AGE = Duration.ofMinutes(1L);
    private final ReadonlyFlag readonlyFlag;
    private final LoadingCache<Path, String> longNames;

    @Inject
    public LongFileNameProvider(ReadonlyFlag readonlyFlag) {
        this.readonlyFlag = readonlyFlag;
        this.longNames = CacheBuilder.newBuilder().expireAfterAccess(MAX_CACHE_AGE).build((CacheLoader)new Loader());
    }

    public boolean isDeflated(String possiblyDeflatedFileName) {
        return possiblyDeflatedFileName.endsWith(".c9s");
    }

    public String inflate(Path c9sPath) throws IOException {
        try {
            return (String)this.longNames.get((Object)c9sPath);
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    public DeflatedFileName deflate(Path c9rPath) {
        String longFileName = c9rPath.getFileName().toString();
        byte[] longFileNameBytes = longFileName.getBytes(StandardCharsets.UTF_8);
        byte[] hash = MessageDigestSupplier.SHA1.get().digest(longFileNameBytes);
        String shortName = BASE64.encode(hash) + ".c9s";
        Path c9sPath = c9rPath.resolveSibling(shortName);
        this.longNames.put((Object)c9sPath, (Object)longFileName);
        return new DeflatedFileName(c9sPath, longFileName, this.readonlyFlag);
    }

    private class Loader
    extends CacheLoader<Path, String> {
        private Loader() {
        }

        public String load(Path c9sPath) throws IOException {
            Path longNameFile = c9sPath.resolve("name.c9s");
            try (SeekableByteChannel ch = Files.newByteChannel(longNameFile, StandardOpenOption.READ);){
                if (ch.size() > 10240L) {
                    throw new IOException("Unexpectedly large file: " + longNameFile);
                }
                assert (ch.size() <= 10240L);
                ByteBuffer buf = ByteBuffer.allocate((int)ch.size());
                ch.read(buf);
                buf.flip();
                String string = StandardCharsets.UTF_8.decode(buf).toString();
                return string;
            }
        }
    }

    public static class DeflatedFileName {
        public final Path c9sPath;
        public final String longName;
        private final ReadonlyFlag readonlyFlag;

        DeflatedFileName(Path c9sPath, String longName, ReadonlyFlag readonlyFlag) {
            this.c9sPath = c9sPath;
            this.longName = longName;
            this.readonlyFlag = readonlyFlag;
        }

        public void persist() {
            this.readonlyFlag.assertWritable();
            try {
                this.persistInternal();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void persistInternal() throws IOException {
            Path longNameFile = this.c9sPath.resolve("name.c9s");
            Files.createDirectories(this.c9sPath, new FileAttribute[0]);
            Files.writeString(longNameFile, (CharSequence)this.longName, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
    }
}

