/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.zn;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.HashIntoGroup;
import org.cryptimeleon.math.structures.groups.RingGroup;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZn;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class HashIntoZnAdditiveGroup
implements HashIntoGroup {
    protected HashIntoZn znHash;
    protected RingGroup structure;

    public HashIntoZnAdditiveGroup(BigInteger n) {
        this(new HashIntoZn(n));
    }

    public HashIntoZnAdditiveGroup(Zn ring) {
        this(new HashIntoZn(ring.n));
    }

    public HashIntoZnAdditiveGroup(Representation repr) {
        this(new HashIntoZn(repr));
    }

    public HashIntoZnAdditiveGroup(HashIntoZn hashIntoZn) {
        this.znHash = hashIntoZn;
        this.structure = this.znHash.getTargetStructure().asAdditiveGroup();
    }

    @Override
    public RingGroup.RingGroupElement hash(byte[] x) {
        return this.structure.getElement(this.znHash.hash(x));
    }

    @Override
    public Representation getRepresentation() {
        return this.znHash.getRepresentation();
    }

    public int hashCode() {
        return Objects.hash(this.znHash, this.structure);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashIntoZnAdditiveGroup other = (HashIntoZnAdditiveGroup)obj;
        return Objects.equals(this.znHash, other.znHash);
    }
}

