/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.zn;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.hash.impl.VariableOutputLengthHashFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.HashIntoStructure;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class HashIntoZn
implements HashIntoStructure {
    @Represented
    protected HashFunction hashIntoZn;
    @Represented
    protected Zn structure;

    public HashIntoZn(HashFunction hashFunction, Zn zn) {
        if (zn.getCharacteristic().bitLength() - 1 < 8) {
            throw new IllegalArgumentException("HashIntoZn requires n to be at least 2^8, but given n is " + zn.getCharacteristic());
        }
        this.structure = zn;
        this.hashIntoZn = new VariableOutputLengthHashFunction(hashFunction, (zn.getCharacteristic().bitLength() - 1) / 8);
    }

    public HashIntoZn(HashFunction hashFunction, BigInteger n) {
        this(hashFunction, new Zn(n));
    }

    public HashIntoZn(BigInteger n) {
        this(new Zn(n));
    }

    public HashIntoZn(Zn zn) {
        this((HashFunction)new SHA256HashFunction(), zn);
    }

    public HashIntoZn(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public Zn.ZnElement hash(byte[] x) {
        byte[] hash = this.hashIntoZn.hash(x);
        return this.structure.injectiveValueOf(hash);
    }

    @Override
    public Zn.ZnElement hash(String x) {
        return (Zn.ZnElement)HashIntoStructure.super.hash(x);
    }

    public Zn getTargetStructure() {
        return this.structure;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hashIntoZn == null ? 0 : this.hashIntoZn.hashCode());
        result = 31 * result + (this.structure == null ? 0 : this.structure.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashIntoZn other = (HashIntoZn)obj;
        return Objects.equals(this.hashIntoZn, other.hashIntoZn) && Objects.equals(this.structure, other.structure);
    }
}

