/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.structures.Structure;
import org.cryptimeleon.math.structures.groups.RingGroup;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;

public interface Ring
extends Structure,
RepresentationRestorer {
    default public RingGroup asAdditiveGroup() {
        return RingGroup.additiveGroupOf(this);
    }

    default public RingGroup asUnitGroup() {
        return RingGroup.unitGroupOf(this);
    }

    public BigInteger sizeUnitGroup() throws UnsupportedOperationException;

    public RingElement getZeroElement();

    public RingElement getOneElement();

    @Override
    public RingElement restoreElement(Representation var1);

    default public RingElementVector restoreVector(Representation repr) {
        return RingElementVector.fromStream(repr.list().stream().map(this::restoreElement));
    }

    @Override
    default public Object restoreFromRepresentation(Type type, Representation repr) {
        if (type instanceof Class && RingElement.class.isAssignableFrom((Class)type)) {
            return this.restoreElement(repr);
        }
        if (type instanceof Class && RingElementVector.class.isAssignableFrom((Class)type)) {
            return this.restoreVector(repr);
        }
        throw new IllegalArgumentException("Group cannot recreate type " + type.getTypeName() + " from representation");
    }

    @Override
    public RingElement getUniformlyRandomElement() throws UnsupportedOperationException;

    default public RingElementVector getUniformlyRandomElements(int n) throws UnsupportedOperationException {
        return RingElementVector.generate(this::getUniformlyRandomElement, n);
    }

    default public RingElement getUniformlyRandomUnit() throws UnsupportedOperationException {
        try {
            RingElement result;
            while (!(result = this.getUniformlyRandomElement()).isUnit()) {
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    default public RingElementVector getUniformlyRandomUnits(int n) throws UnsupportedOperationException {
        return RingElementVector.generate(this::getUniformlyRandomUnit, n);
    }

    default public RingElement getUniformlyRandomNonzeroElement() {
        try {
            RingElement result;
            while ((result = this.getUniformlyRandomElement()).isZero()) {
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    default public RingElementVector getUniformlyRandomNonzeroElements(int n) {
        return RingElementVector.generate(this::getUniformlyRandomNonzeroElement, n);
    }

    public BigInteger getCharacteristic() throws UnsupportedOperationException;

    public RingElement getElement(BigInteger var1);

    default public RingElement getElement(long i) {
        return this.getElement(BigInteger.valueOf(i));
    }

    default public RingElement[] extendedEuclideanAlgorithm(RingElement a, RingElement b) {
        RingElement x = this.getZeroElement();
        RingElement prevx = this.getOneElement();
        RingElement y = this.getOneElement();
        RingElement prevy = this.getZeroElement();
        while (!b.isZero()) {
            RingElement[] divisionAndRemainder = a.divideWithRemainder(b);
            RingElement q = divisionAndRemainder[0];
            RingElement r = divisionAndRemainder[1];
            RingElement tmp = x;
            x = prevx.sub(q.mul(x));
            prevx = tmp;
            tmp = y;
            y = prevy.sub(q.mul(y));
            prevy = tmp;
            a = b;
            b = r;
        }
        return new RingElement[]{prevx, prevy, a};
    }

    default public ArrayList<RingElement> extendedEuclideanAlgorithm(List<RingElement> elements) {
        if (elements == null || elements.size() == 0) {
            return new ArrayList<RingElement>(Collections.singleton(this.getOneElement()));
        }
        if (elements.size() == 1) {
            return new ArrayList<RingElement>(Arrays.asList(this.getOneElement(), elements.get(0)));
        }
        ArrayList<RingElement> result = this.extendedEuclideanAlgorithm(elements.subList(0, elements.size() - 1));
        RingElement missingElement = elements.get(elements.size() - 1);
        RingElement[] tmp = this.extendedEuclideanAlgorithm(result.get(result.size() - 1), missingElement);
        for (int i = 0; i < result.size() - 1; ++i) {
            result.set(i, result.get(i).mul(tmp[0]));
        }
        result.set(result.size() - 1, tmp[1]);
        result.add(tmp[2]);
        return result;
    }

    public double estimateCostInvPerOp();

    public double estimateCostNegPerOp();

    public boolean isCommutative();
}

