/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings;

import java.math.BigInteger;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.RingElement;

public interface FieldElement
extends RingElement {
    @Override
    public FieldElement add(Element var1);

    @Override
    public FieldElement neg();

    @Override
    default public FieldElement sub(Element e) {
        return (FieldElement)RingElement.super.sub(e);
    }

    @Override
    public FieldElement mul(Element var1);

    @Override
    default public FieldElement mul(BigInteger k) {
        return (FieldElement)RingElement.super.mul(k);
    }

    @Override
    default public FieldElement mul(long k) {
        return this.mul(BigInteger.valueOf(k));
    }

    @Override
    default public FieldElement pow(BigInteger k) {
        return (FieldElement)RingElement.super.pow(k);
    }

    @Override
    default public FieldElement pow(long k) {
        return this.pow(BigInteger.valueOf(k));
    }

    @Override
    public FieldElement inv() throws UnsupportedOperationException;

    @Override
    default public FieldElement div(Element e) throws IllegalArgumentException {
        return (FieldElement)RingElement.super.div(e);
    }

    @Override
    default public FieldElement square() {
        return (FieldElement)RingElement.super.square();
    }

    @Override
    public Field getStructure();

    @Override
    default public boolean divides(RingElement e) throws UnsupportedOperationException {
        return this.isZero() == e.isZero();
    }

    @Override
    default public RingElement[] divideWithRemainder(RingElement e) throws UnsupportedOperationException, IllegalArgumentException {
        if (e.isZero()) {
            throw new IllegalArgumentException("Division by zero");
        }
        return new FieldElement[]{this.div(e), this.getStructure().getZeroElement()};
    }

    @Override
    default public BigInteger getRank() throws UnsupportedOperationException {
        return BigInteger.ZERO;
    }

    default public FieldElement applyFrobenius() {
        return this.pow(this.getStructure().getCharacteristic());
    }

    default public FieldElement applyFrobenius(int numberOfApplications) {
        FieldElement result = this;
        for (int i = 0; i < numberOfApplications; ++i) {
            result = result.applyFrobenius();
        }
        return result;
    }
}

