/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.lazy;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.HashIntoGroup;
import org.cryptimeleon.math.structures.groups.lazy.HashResultLazyGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;

public class HashIntoLazyGroup
implements HashIntoGroup {
    @Represented
    protected HashIntoGroupImpl impl;
    @Represented
    protected LazyGroup target;

    public HashIntoLazyGroup(HashIntoGroupImpl hash, LazyGroup target) {
        this.impl = hash;
        this.target = target;
    }

    public HashIntoLazyGroup(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public LazyGroupElement hash(byte[] x) {
        return new HashResultLazyGroupElement(this, x);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashIntoLazyGroup)) {
            return false;
        }
        HashIntoLazyGroup that = (HashIntoLazyGroup)o;
        return this.impl.equals(that.impl);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }

    public LazyGroup getTarget() {
        return this.target;
    }
}

