/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type3.bn;

import java.math.BigInteger;
import org.cryptimeleon.math.structures.groups.elliptic.AbstractPairing;
import org.cryptimeleon.math.structures.groups.elliptic.PairingSourceGroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.PairingTargetGroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigGroup1Impl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigGroup2Impl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigTargetGroupImpl;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;

class BarretoNaehrigTatePairing
extends AbstractPairing {
    BigInteger lambda2;
    BigInteger lambda1;
    BigInteger lambda0;

    public BarretoNaehrigTatePairing(BarretoNaehrigGroup1Impl g1, BarretoNaehrigGroup2Impl g2, BarretoNaehrigTargetGroupImpl gT, BigInteger u) {
        super(g1, g2, gT);
        this.lambda2 = u.pow(2).multiply(BigInteger.valueOf(6L)).add(BigInteger.ONE);
        this.lambda1 = u.pow(3).multiply(BigInteger.valueOf(-36L)).add(u.pow(2).multiply(BigInteger.valueOf(-18L))).add(u.multiply(BigInteger.valueOf(-12L))).add(BigInteger.ONE);
        this.lambda0 = u.pow(3).multiply(BigInteger.valueOf(-36L)).add(u.pow(2).multiply(BigInteger.valueOf(-30L))).add(u.multiply(BigInteger.valueOf(-18L))).add(BigInteger.valueOf(-2L));
    }

    @Override
    protected ExtensionFieldElement evaluateLine(FieldElement[] line, PairingSourceGroupElement P, PairingSourceGroupElement Q) {
        ExtensionField targetField = this.gT.getFieldOfDefinition();
        ExtensionField extField = (ExtensionField)Q.getFieldOfDefinition();
        if (!P.isNormalized() || !Q.isNormalized()) {
            throw new IllegalArgumentException("Currently, only affine points are supported.");
        }
        FieldElement[] coefficients = new FieldElement[]{extField.createElement(P.getX().mul(line[1]).sub(P.getY().mul(line[0]))), extField.getZeroElement(), extField.createElement(line[1]).mul(Q.getX()).neg(), Q.getY().mul(extField.createElement(line[0]))};
        return targetField.createElement(coefficients);
    }

    @Override
    protected ExtensionFieldElement pair(PairingSourceGroupElement P, PairingSourceGroupElement Q) {
        ExtensionFieldElement result = this.miller(P, Q, this.g1.size());
        if (result.isZero()) {
            return result.getStructure().getOneElement();
        }
        return result;
    }

    @Override
    public PairingTargetGroupElementImpl exponentiate(FieldElement f) {
        FieldElement result;
        if (this.lambda2 != null) {
            result = f.applyFrobenius(6).div(f);
            result = result.applyFrobenius(2).mul(result);
            FieldElement resultFrob1 = result.applyFrobenius();
            FieldElement resultFrob2 = resultFrob1.applyFrobenius();
            FieldElement resultFrob3 = resultFrob2.applyFrobenius();
            result = resultFrob3.mul(resultFrob2.pow(this.lambda2)).mul(resultFrob1.pow(this.lambda1)).mul(result.pow(this.lambda0));
        } else {
            result = f.pow(this.gT.getCofactor());
        }
        return this.gT.getElement((ExtensionFieldElement)result);
    }

    public String toString() {
        return "Tate Pairing G1xG2->Gt of Type 3";
    }

    @Override
    public boolean isSymmetric() {
        return false;
    }
}

