/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.PairingSourceGroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.WeierstrassCurve;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public abstract class PairingSourceGroupImpl
implements WeierstrassCurve {
    protected BigInteger size;
    protected BigInteger cofactor;
    protected PairingSourceGroupElement generator;
    protected Field field;
    private FieldElement a1;
    private FieldElement a2;
    private FieldElement a3;
    private FieldElement a4;
    private FieldElement a6;

    public BigInteger getSize() {
        return this.size;
    }

    @Override
    public FieldElement getA1() {
        return this.a1;
    }

    @Override
    public FieldElement getA2() {
        return this.a2;
    }

    @Override
    public FieldElement getA3() {
        return this.a3;
    }

    @Override
    public FieldElement getA4() {
        return this.a4;
    }

    @Override
    public FieldElement getA6() {
        return this.a6;
    }

    private void create(BigInteger size, BigInteger cofactor, FieldElement a1, FieldElement a2, FieldElement a3, FieldElement a4, FieldElement a6) {
        this.size = size;
        this.cofactor = cofactor;
        this.field = a1.getStructure();
        this.a1 = a1;
        this.a2 = a2;
        this.a3 = a3;
        this.a4 = a4;
        this.a6 = a6;
    }

    public PairingSourceGroupImpl(BigInteger size, BigInteger cofactor, FieldElement a1, FieldElement a2, FieldElement a3, FieldElement a4, FieldElement a6) {
        this.create(size, cofactor, a1, a2, a3, a4, a6);
    }

    public PairingSourceGroupImpl(BigInteger size, BigInteger cofactor, FieldElement a4, FieldElement a6) {
        this.create(size, cofactor, a4.getStructure().getZeroElement(), a4.getStructure().getZeroElement(), a4.getStructure().getZeroElement(), a4, a6);
    }

    public PairingSourceGroupImpl(Representation repr) {
        ObjectRepresentation or = (ObjectRepresentation)repr;
        this.size = ((BigIntegerRepresentation)or.get("size")).get();
        this.cofactor = ((BigIntegerRepresentation)or.get("cofactor")).get();
        this.field = (Field)((RepresentableRepresentation)or.get("field")).recreateRepresentable();
        this.a1 = this.field.restoreElement(or.get("a1"));
        this.a2 = this.field.restoreElement(or.get("a2"));
        this.a3 = this.field.restoreElement(or.get("a3"));
        this.a4 = this.field.restoreElement(or.get("a4"));
        this.a6 = this.field.restoreElement(or.get("a6"));
        this.setGenerator(this.restoreElement(or.get("generator")));
    }

    @Override
    public PairingSourceGroupElement getGenerator() {
        return this.generator;
    }

    public void setGenerator(PairingSourceGroupElement generator) {
        this.generator = generator;
    }

    public BigInteger getCofactor() {
        return this.cofactor;
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.size;
    }

    @Override
    public Representation getRepresentation() {
        ObjectRepresentation or = new ObjectRepresentation();
        or.put("size", new BigIntegerRepresentation(this.size));
        or.put("cofactor", new BigIntegerRepresentation(this.getCofactor()));
        or.put("generator", this.getGenerator().getRepresentation());
        or.put("field", new RepresentableRepresentation(this.field));
        or.put("a1", this.a1.getRepresentation());
        or.put("a2", this.a2.getRepresentation());
        or.put("a3", this.a3.getRepresentation());
        or.put("a4", this.a4.getRepresentation());
        or.put("a6", this.a6.getRepresentation());
        return or;
    }

    public boolean isOnCurve(FieldElement x, FieldElement y) {
        return x.mul(this.getA1()).add(this.getA3()).mul(y).add(y).mul(y).equals(x.add(this.getA2()).mul(x).add(this.getA4()).mul(x).add(this.getA6()));
    }

    public boolean isMember(FieldElement x, FieldElement y) {
        if (!this.size().gcd(this.getCofactor()).equals(BigInteger.ONE)) {
            throw new IllegalArgumentException("Require cofactor coprime to order of subgroup.");
        }
        if (!this.isOnCurve(x, y)) {
            return false;
        }
        return this.getElement(x, y).pow(this.size()).isNeutralElement();
    }

    @Override
    public Field getFieldOfDefinition() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PairingSourceGroupImpl that = (PairingSourceGroupImpl)o;
        return this.size.equals(that.size) && this.cofactor.equals(that.cofactor) && this.generator.equals(that.generator) && this.field.equals(that.field) && Objects.equals(this.a1, that.a1) && Objects.equals(this.a2, that.a2) && Objects.equals(this.a3, that.a3) && Objects.equals(this.a4, that.a4) && Objects.equals(this.a6, that.a6);
    }

    public int hashCode() {
        return Objects.hash(this.size);
    }

    @Override
    public PairingSourceGroupElement getUniformlyRandomElement() throws UnsupportedOperationException {
        Zp zp = new Zp(this.size());
        return (PairingSourceGroupElement)this.getGenerator().pow(zp.getUniformlyRandomElement().asInteger());
    }

    @Override
    public PairingSourceGroupElement restoreElement(Representation repr) {
        ObjectRepresentation or = (ObjectRepresentation)repr;
        FieldElement x = this.getFieldOfDefinition().restoreElement(or.get("x"));
        FieldElement y = this.getFieldOfDefinition().restoreElement(or.get("y"));
        FieldElement z = this.getFieldOfDefinition().restoreElement(or.get("z"));
        if (z.isZero()) {
            return (PairingSourceGroupElement)this.getNeutralElement();
        }
        return this.getElement(x, y);
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return this.getFieldOfDefinition().getUniqueByteLength().map(k -> k * 3);
    }

    @Override
    public abstract PairingSourceGroupElement getElement(FieldElement var1, FieldElement var2);

    public PairingSourceGroupElement multiplyByCofactor(FieldElement x, FieldElement y) {
        PairingSourceGroupElement elem = this.getElement(x, y);
        return this.multiplyByCofactor(elem);
    }

    public PairingSourceGroupElement multiplyByCofactor(GroupElementImpl element) {
        GroupElementImpl result = this.getNeutralElement();
        for (int i = this.cofactor.bitLength() - 1; i >= 0; --i) {
            result = result.op(result);
            if (!this.cofactor.testBit(i)) continue;
            result = result.op(element);
        }
        return (PairingSourceGroupElement)result;
    }
}

