/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic;

import java.math.BigInteger;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.HashIntoGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.mappings.GroupHomomorphism;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZn;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public interface BilinearGroup
extends StandaloneRepresentable {
    public Group getG1();

    public Group getG2();

    public Group getGT();

    public BilinearMap getBilinearMap();

    public GroupHomomorphism getHomomorphismG2toG1() throws UnsupportedOperationException;

    public HashIntoGroup getHashIntoG1() throws UnsupportedOperationException;

    public HashIntoGroup getHashIntoG2() throws UnsupportedOperationException;

    public HashIntoGroup getHashIntoGT() throws UnsupportedOperationException;

    public Integer getSecurityLevel();

    public Type getPairingType();

    default public HashIntoZn getHashIntoZGroupExponent() throws UnsupportedOperationException {
        return new HashIntoZn(this.getZn());
    }

    default public Zn getZn() {
        return this.getG1().getZn();
    }

    default public BigInteger size() {
        return this.getG1().size();
    }

    public static enum Type {
        TYPE_1,
        TYPE_2,
        TYPE_3;

    }
}

