/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.debug.DebugGroup;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupHomomorphism;
import org.cryptimeleon.math.structures.groups.mappings.GroupHomomorphism;

public class DebugHomomorphism
implements GroupHomomorphism {
    @Represented
    private LazyGroupHomomorphism totalHom;
    @Represented
    private LazyGroupHomomorphism expMultiExpHom;

    public DebugHomomorphism(LazyGroupHomomorphism totalHom, LazyGroupHomomorphism expMultiExpHom) {
        this.totalHom = totalHom;
        this.expMultiExpHom = expMultiExpHom;
    }

    public DebugHomomorphism(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public GroupElement apply(GroupElement groupElement) {
        return new DebugGroupElement(new DebugGroup(this.totalHom.getTargetGroup(), this.expMultiExpHom.getTargetGroup()), this.totalHom.apply(((DebugGroupElement)groupElement).elemTotal), this.expMultiExpHom.apply(((DebugGroupElement)groupElement).elemExpMultiExp));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugHomomorphism that = (DebugHomomorphism)o;
        return Objects.equals(this.totalHom, that.totalHom) && Objects.equals(this.expMultiExpHom, that.expMultiExpHom);
    }

    public int hashCode() {
        return Objects.hash(this.totalHom, this.expMultiExpHom);
    }
}

