/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.debug.CountingBucket;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupElementImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImpl;
import org.cryptimeleon.math.structures.groups.exp.MultiExpTerm;
import org.cryptimeleon.math.structures.groups.exp.Multiexponentiation;
import org.cryptimeleon.math.structures.groups.exp.SmallExponentPrecomputation;

public class DebugGroupImplNoExpMultiExp
extends DebugGroupImpl {
    private static final ConcurrentHashMap<String, CountingBucket> countingBucketMap = new ConcurrentHashMap();
    private static final CountingBucket defaultBucket;
    private static volatile CountingBucket currentBucket;

    public DebugGroupImplNoExpMultiExp(String name, BigInteger n) {
        super(name, n);
    }

    public DebugGroupImplNoExpMultiExp(Representation repr) {
        super(repr);
    }

    @Override
    public GroupElementImpl exp(GroupElementImpl base, BigInteger exponent, SmallExponentPrecomputation precomputation) {
        return base.pow(exponent);
    }

    @Override
    public GroupElementImpl multiexp(Multiexponentiation mexp) {
        DebugGroupElementImpl result = (DebugGroupElementImpl)mexp.getConstantFactor().orElse(this.getNeutralElement());
        for (MultiExpTerm term : mexp.getTerms()) {
            result = (DebugGroupElementImpl)result.op(((DebugGroupElementImpl)term.getBase()).pow(term.getExponent(), false), false);
        }
        this.addMultiExpBaseNumber(mexp.getTerms().size());
        return result;
    }

    @Override
    public boolean implementsOwnExp() {
        return true;
    }

    @Override
    public boolean implementsOwnMultiExp() {
        return true;
    }

    @Override
    void setBucket(String name) {
        currentBucket = this.putBucketIfAbsent(name);
    }

    @Override
    void setDefaultBucket() {
        currentBucket = this.getDefaultBucket();
    }

    @Override
    CountingBucket putBucketIfAbsent(String name) {
        return this.getBucketMap().computeIfAbsent(name, kName -> new CountingBucket());
    }

    @Override
    CountingBucket getCurrentBucket() {
        return currentBucket;
    }

    @Override
    CountingBucket getDefaultBucket() {
        return defaultBucket;
    }

    @Override
    Map<String, CountingBucket> getBucketMap() {
        return countingBucketMap;
    }

    static {
        currentBucket = defaultBucket = new CountingBucket();
    }
}

