/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Optional;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.exp.Multiexponentiation;
import org.cryptimeleon.math.structures.groups.exp.SmallExponentPrecomputation;

public interface GroupImpl
extends StandaloneRepresentable,
RepresentationRestorer {
    public GroupElementImpl getNeutralElement();

    public GroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException;

    default public GroupElementImpl getUniformlyRandomNonNeutral() throws UnsupportedOperationException {
        GroupElementImpl result;
        while ((result = this.getUniformlyRandomElement()).isNeutralElement()) {
        }
        return result;
    }

    public GroupElementImpl restoreElement(Representation var1);

    public GroupElementImpl getGenerator() throws UnsupportedOperationException;

    public boolean isCommutative();

    public BigInteger size() throws UnsupportedOperationException;

    public boolean hasPrimeSize();

    default public boolean implementsOwnExp() {
        return false;
    }

    default public GroupElementImpl exp(GroupElementImpl base, BigInteger exponent, SmallExponentPrecomputation precomputation) {
        throw new UnsupportedOperationException("Exponentiation is not implemented for group " + this);
    }

    default public boolean implementsOwnMultiExp() {
        return false;
    }

    default public GroupElementImpl multiexp(Multiexponentiation mexp) {
        throw new UnsupportedOperationException("Multi-exponentiation is not implemented for group " + this);
    }

    public double estimateCostInvPerOp();

    @Override
    default public GroupElementImpl restoreFromRepresentation(Type type, Representation repr) {
        if (!(type instanceof Class) || !GroupElementImpl.class.isAssignableFrom((Class)type)) {
            throw new IllegalArgumentException("Group cannot recreate type " + type.getTypeName() + " from representation");
        }
        return this.restoreElement(repr);
    }

    public Optional<Integer> getUniqueByteLength();
}

