/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups;

import java.math.BigInteger;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.structures.groups.GroupImpl;

public interface GroupElementImpl
extends Representable,
UniqueByteRepresentable {
    public GroupImpl getStructure();

    public GroupElementImpl inv();

    public GroupElementImpl op(GroupElementImpl var1) throws IllegalArgumentException;

    default public GroupElementImpl square() {
        return this.op(this);
    }

    default public GroupElementImpl pow(BigInteger k) {
        if (k.signum() < 0) {
            return this.pow(k.negate()).inv();
        }
        GroupElementImpl operand = this;
        GroupElementImpl result = this.getStructure().getNeutralElement();
        for (int i = k.bitLength() - 1; i >= 0; --i) {
            result = result.op(result);
            if (!k.testBit(i)) continue;
            result = result.op(operand);
        }
        return result;
    }

    default public boolean isNeutralElement() {
        return this.equals(this.getStructure().getNeutralElement());
    }
}

