/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.annotations;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.UUID;
import java.util.function.Function;
import org.cryptimeleon.math.misc.BigIntegerTools;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ByteArrayRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.StringRepresentation;
import org.cryptimeleon.math.serialization.annotations.RepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;

class StandaloneRepresentationHandler
implements RepresentationHandler {
    private static final Class<?>[] supportedTypes = new Class[]{StandaloneRepresentable.class, BigInteger.class, Integer.class, Long.class, String.class, Boolean.class, byte[].class, UUID.class, Enum.class};
    protected Class<?> type;

    public StandaloneRepresentationHandler(Class<?> type) {
        this.type = type;
    }

    public static boolean canHandle(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        for (Class<?> supported : supportedTypes) {
            if (!supported.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object deserializeFromRepresentation(Representation repr, Function<String, RepresentationRestorer> getRegisteredRestorer) {
        if (repr == null) {
            return null;
        }
        try {
            if (repr instanceof RepresentableRepresentation && this.type.isAssignableFrom(Class.forName(repr.repr().getRepresentedTypeName()))) {
                return repr.repr().recreateRepresentable();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Don't know how to recreate " + repr.repr().getRepresentedTypeName() + " - Class not found.", e);
        }
        if (this.type.isAssignableFrom(BigInteger.class) && repr instanceof BigIntegerRepresentation) {
            return repr.bigInt().get();
        }
        if (this.type.isAssignableFrom(Integer.class) && repr instanceof BigIntegerRepresentation) {
            return BigIntegerTools.getExactInt(repr.bigInt().get());
        }
        if (this.type.isAssignableFrom(Long.class) && repr instanceof BigIntegerRepresentation) {
            return BigIntegerTools.getExactLong(repr.bigInt().get());
        }
        if (this.type.isAssignableFrom(String.class) && repr instanceof StringRepresentation) {
            return repr.str().get();
        }
        if (this.type.isAssignableFrom(Boolean.class) && repr instanceof BigIntegerRepresentation) {
            return !repr.bigInt().get().equals(BigInteger.ZERO);
        }
        if (this.type.isAssignableFrom(byte[].class) && repr instanceof ByteArrayRepresentation) {
            return repr.bytes().get();
        }
        if (this.type.isAssignableFrom(UUID.class) && repr instanceof StringRepresentation) {
            return UUID.fromString(repr.str().get());
        }
        throw new IllegalArgumentException("Don't know how to recreate " + this.type.getName() + " from a " + repr.getClass().getName());
    }

    @Override
    public Representation serializeToRepresentation(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return new RepresentableRepresentation(enumValue);
        }
        if (value instanceof StandaloneRepresentable) {
            Representable repr = (Representable)value;
            return new RepresentableRepresentation(repr);
        }
        if (value instanceof Representable) {
            Representable repr = (Representable)value;
            return repr.getRepresentation();
        }
        if (value instanceof BigInteger) {
            BigInteger bigInt = (BigInteger)value;
            return new BigIntegerRepresentation(bigInt);
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return new BigIntegerRepresentation(integer.intValue());
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return new BigIntegerRepresentation(longValue);
        }
        if (value instanceof String) {
            String string = (String)value;
            return new StringRepresentation(string);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return new BigIntegerRepresentation(bool != false ? 1L : 0L);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return new ByteArrayRepresentation(bytes);
        }
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return new StringRepresentation(uuid.toString());
        }
        throw new IllegalArgumentException("Do not know how to handle object of type " + value.getClass().getName() + ". You may have to add an explicit 'restorer' argument to the @Represented annotation");
    }
}

