/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.prf.aes;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.cryptimeleon.math.misc.ByteArrayImpl;
import org.cryptimeleon.math.prf.PrfImage;
import org.cryptimeleon.math.prf.PrfKey;
import org.cryptimeleon.math.prf.PrfPreimage;
import org.cryptimeleon.math.prf.PseudorandomFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class AesPseudorandomFunction
implements PseudorandomFunction {
    @Represented
    protected Integer keylength;

    public AesPseudorandomFunction(int keylength) {
        this.keylength = keylength;
    }

    public AesPseudorandomFunction(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public PrfKey generateKey() {
        return ByteArrayImpl.fromRandom(this.keylength / 8);
    }

    @Override
    public PrfImage evaluate(PrfKey k, PrfPreimage x) {
        if (((ByteArrayImpl)k).length() != this.keylength / 8) {
            throw new IllegalArgumentException("key k in the AES PRF has invalid length");
        }
        if (((ByteArrayImpl)x).length() != this.keylength / 8) {
            throw new IllegalArgumentException("preimage x in the AES PRF has invalid length");
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(((ByteArrayImpl)k).getData(), "AES");
            cipher.init(1, keySpec);
            return new ByteArrayImpl(cipher.doFinal(((ByteArrayImpl)x).getData()));
        }
        catch (NoSuchAlgorithmException | BadPaddingException | NoSuchPaddingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Input k to AES PRF must be of valid AES key length");
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Input x to AES PRF must be of valid AES key length");
        }
    }

    @Override
    public PrfKey restoreKey(Representation repr) {
        return new ByteArrayImpl(repr);
    }

    @Override
    public PrfPreimage restorePreimage(Representation repr) {
        return new ByteArrayImpl(repr);
    }

    @Override
    public PrfImage restoreImage(Representation repr) {
        return new ByteArrayImpl(repr);
    }

    public int hashCode() {
        return this.keylength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AesPseudorandomFunction other = (AesPseudorandomFunction)o;
        return Objects.equals(this.keylength, other.keylength);
    }

    public Integer getKeylength() {
        return this.keylength;
    }
}

