/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.hash.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.EscapingByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.hash.impl.ByteArrayAccumulator;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.Structure;

public class AnnotatedUbrUtil {
    protected static final byte nullSymbol = 127;
    protected static final List<Class<? extends Annotation>> annotationClassList = Arrays.asList(UniqueByteRepresented.class);

    public static ByteAccumulator autoAccumulate(ByteAccumulator accumulator, Object instance) {
        ArrayList<Object> accumulatableObjects = new ArrayList<Object>();
        try {
            Class<?> clazz = instance.getClass();
            while (!clazz.equals(Object.class)) {
                for (Field field : Arrays.stream(clazz.getDeclaredFields()).sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList())) {
                    field.setAccessible(true);
                    Object fieldValue = field.get(instance);
                    if (!AnnotatedUbrUtil.hasAnnotation(field)) continue;
                    accumulatableObjects.add(fieldValue);
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
        return AnnotatedUbrUtil.accumulateList(accumulator, accumulatableObjects);
    }

    private static ByteAccumulator accumulateObject(ByteAccumulator accumulator, Object obj) {
        if (obj == null) {
            accumulator.append(new byte[]{127});
            return accumulator;
        }
        EscapingByteAccumulator nonNullAcc = new EscapingByteAccumulator(accumulator, 127);
        if (obj instanceof UniqueByteRepresentable) {
            ((UniqueByteRepresentable)obj).updateAccumulator(nonNullAcc);
            return accumulator;
        }
        if (obj instanceof byte[]) {
            ((ByteAccumulator)nonNullAcc).append((byte[])obj);
            return accumulator;
        }
        if (obj instanceof Byte) {
            nonNullAcc.append((Byte)obj);
            return accumulator;
        }
        if (obj instanceof String) {
            ((ByteAccumulator)nonNullAcc).append(((String)obj).getBytes(StandardCharsets.UTF_8));
            return accumulator;
        }
        if (obj instanceof Integer) {
            nonNullAcc.append((Integer)obj);
            return accumulator;
        }
        if (obj instanceof BigInteger) {
            ((ByteAccumulator)nonNullAcc).append(((BigInteger)obj).toByteArray());
            return accumulator;
        }
        if (obj instanceof List) {
            AnnotatedUbrUtil.accumulateList(nonNullAcc, (List)obj);
            return accumulator;
        }
        if (obj.getClass().isArray()) {
            AnnotatedUbrUtil.accumulateList(nonNullAcc, Arrays.asList((Object[])obj));
            return accumulator;
        }
        if (obj instanceof Enum) {
            nonNullAcc.append(((Enum)obj).ordinal());
            return accumulator;
        }
        if (obj instanceof Map) {
            AnnotatedUbrUtil.accumulateMap(nonNullAcc, (Map)obj);
            return accumulator;
        }
        if (obj instanceof Set) {
            AnnotatedUbrUtil.accumulateSet(nonNullAcc, (Set)obj);
            return accumulator;
        }
        throw new IllegalArgumentException("Don't know how to unique-byte-represent an object of type " + obj.getClass().getName());
    }

    private static ByteAccumulator accumulateList(ByteAccumulator accumulator, List objects) {
        Structure structure;
        if (objects.size() > 0 && objects.stream().allMatch(o -> o instanceof Element) && (structure = ((Element)objects.get(0)).getStructure()).getUniqueByteLength().isPresent() && objects.stream().map(e -> ((Element)e).getStructure()).allMatch(s -> s.equals(structure))) {
            for (Object obj : objects) {
                AnnotatedUbrUtil.accumulateObject(accumulator, obj);
            }
        }
        for (Object obj : objects) {
            AnnotatedUbrUtil.accumulateObject(new EscapingByteAccumulator(accumulator), obj);
            accumulator.appendSeperator();
        }
        return accumulator;
    }

    private static ByteAccumulator accumulateSet(ByteAccumulator accumulator, Set obj) {
        byte[][] ubrs = new byte[obj.size()][];
        int i = 0;
        for (Object obj2 : obj) {
            ByteArrayAccumulator acc = new ByteArrayAccumulator();
            AnnotatedUbrUtil.accumulateObject(acc, obj2);
            ubrs[i++] = ((ByteAccumulator)acc).extractBytes();
        }
        Arrays.sort(ubrs, (o1, o2) -> {
            if (((byte[])o1).length < ((byte[])o2).length) {
                return -1;
            }
            if (((byte[])o1).length > ((byte[])o2).length) {
                return 1;
            }
            for (int j = 0; j < ((byte[])o1).length; ++j) {
                if (o1[j] < o2[j]) {
                    return -1;
                }
                if (o1[j] <= o2[j]) continue;
                return 1;
            }
            return 0;
        });
        return AnnotatedUbrUtil.accumulateList(accumulator, Arrays.asList(ubrs));
    }

    private static ByteAccumulator accumulateMap(ByteAccumulator accumulator, Map obj) {
        byte[][][] ubrs = new byte[obj.size()][][];
        int i = 0;
        for (Object key : obj.keySet()) {
            ByteArrayAccumulator accKey = new ByteArrayAccumulator();
            ByteArrayAccumulator accVal = new ByteArrayAccumulator();
            AnnotatedUbrUtil.accumulateObject(accKey, key);
            AnnotatedUbrUtil.accumulateObject(accVal, obj.get(key));
            ubrs[i++] = new byte[][]{((ByteAccumulator)accKey).extractBytes(), ((ByteAccumulator)accVal).extractBytes()};
        }
        Arrays.sort(ubrs, (o1, o2) -> {
            byte[] key1 = o1[0];
            byte[] key2 = o2[0];
            if (key1.length < key2.length) {
                return -1;
            }
            if (key1.length > key2.length) {
                return 1;
            }
            for (int j = 0; j < key1.length; ++j) {
                if (key1[j] < key2[j]) {
                    return -1;
                }
                if (key1[j] <= key2[j]) continue;
                return 1;
            }
            return 0;
        });
        return AnnotatedUbrUtil.accumulateList(accumulator, Arrays.asList(ubrs));
    }

    private static boolean hasAnnotation(Field field) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        if (annotations == null || annotations.length == 0) {
            return false;
        }
        return Arrays.stream(annotations).map(Annotation::annotationType).anyMatch(a -> annotationClassList.parallelStream().anyMatch(a::isAssignableFrom));
    }
}

