/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.exponent;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.EvaluationException;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.exponent.ExponentEmptyExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentSumExpr;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public interface ExponentVariableExpr
extends ExponentExpr,
VariableExpression {
    @Override
    default public BigInteger evaluate() {
        throw new EvaluationException(this, "Variable cannot be evaluated");
    }

    @Override
    default public void forEachChild(Consumer<Expression> action) {
    }

    @Override
    default public Zn.ZnElement evaluate(Zn zn) {
        throw new EvaluationException(this, "Variable cannot be evaluated");
    }

    @Override
    default public BigInteger evaluate(Substitution substitutions) {
        ExponentExpr substitution = (ExponentExpr)substitutions.getSubstitution(this);
        if (substitution == null) {
            throw new EvaluationException(this, "Variable cannot be evaluated");
        }
        return substitution.evaluate();
    }

    @Override
    default public Zn.ZnElement evaluate(Zn zn, Substitution substitutions) {
        ExponentExpr substitution = (ExponentExpr)substitutions.getSubstitution(this);
        if (substitution == null) {
            throw new EvaluationException(this, "Variable cannot be evaluated");
        }
        return substitution.evaluate(zn);
    }

    @Override
    default public ExponentExpr substitute(Substitution substitutions) {
        Expression replacement = substitutions.getSubstitution(this);
        if (replacement != null) {
            return (ExponentExpr)replacement;
        }
        return this;
    }

    @Override
    default public ExponentSumExpr linearize() throws IllegalArgumentException {
        return new ExponentSumExpr(new ExponentEmptyExpr(), this);
    }
}

