/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.bool;

import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.EvaluationException;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.expressions.bool.LazyBoolEvaluationResult;

public interface BoolVariableExpr
extends VariableExpression,
BooleanExpression {
    @Override
    default public Boolean evaluate() {
        throw new EvaluationException(this, "Variable has no value");
    }

    @Override
    default public Boolean evaluate(Substitution substitutions) {
        BooleanExpression substitution = (BooleanExpression)substitutions.getSubstitution(this);
        if (substitution == null) {
            throw new EvaluationException(this, "Variable cannot be evaluated");
        }
        return substitution.evaluate();
    }

    @Override
    default public void forEachChild(Consumer<Expression> action) {
    }

    @Override
    default public BooleanExpression substitute(Substitution substitutions) {
        Expression replacement = substitutions.getSubstitution(this);
        if (replacement != null) {
            return (BooleanExpression)replacement;
        }
        return this;
    }

    @Override
    default public LazyBoolEvaluationResult evaluateLazy(Substitution substitutions) {
        BooleanExpression substitution = (BooleanExpression)substitutions.getSubstitution(this);
        if (substitution == null) {
            throw new EvaluationException(this, "Variable cannot be evaluated");
        }
        return substitution.evaluateLazy();
    }
}

