/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.bool;

import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.expressions.bool.LazyBoolEvaluationResult;

public class BoolAndExpr
implements BooleanExpression {
    protected final BooleanExpression lhs;
    protected final BooleanExpression rhs;

    public BoolAndExpr(BooleanExpression lhs, BooleanExpression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public BooleanExpression substitute(Substitution substitutions) {
        return this.lhs.substitute(substitutions).and(this.rhs.substitute(substitutions));
    }

    @Override
    public Boolean evaluate(Substitution substitutions) {
        return this.lhs.evaluate(substitutions) != false && this.rhs.evaluate(substitutions) != false;
    }

    @Override
    public LazyBoolEvaluationResult evaluateLazy(Substitution substitutions) {
        final LazyBoolEvaluationResult lhs = this.lhs.evaluateLazy(substitutions);
        final LazyBoolEvaluationResult rhs = this.rhs.evaluateLazy(substitutions);
        if (lhs.isResultKnown()) {
            return lhs.getResult() ? rhs : LazyBoolEvaluationResult.FALSE;
        }
        if (rhs.isResultKnown()) {
            return rhs.getResult() ? lhs : LazyBoolEvaluationResult.FALSE;
        }
        return new LazyBoolEvaluationResult(){

            @Override
            public boolean getResult() {
                return lhs.getResult() && rhs.getResult();
            }

            @Override
            boolean isResultKnown() {
                return false;
            }
        };
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.lhs);
        action.accept(this.rhs);
    }

    public BooleanExpression getLhs() {
        return this.lhs;
    }

    public BooleanExpression getRhs() {
        return this.rhs;
    }
}

