/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.groth15;

import java.util.Objects;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.MultiMessageStructurePreservingSignatureScheme;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParameters;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15PublicParametersGen;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15Signature;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15SigningKey;
import org.cryptimeleon.craco.sig.sps.groth15.SPSGroth15VerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSGroth15SignatureScheme
implements MultiMessageStructurePreservingSignatureScheme {
    @Represented
    protected SPSGroth15PublicParameters pp;

    protected SPSGroth15SignatureScheme() {
    }

    public SPSGroth15SignatureScheme(SPSGroth15PublicParameters pp) {
        this.pp = pp;
    }

    public SPSGroth15SignatureScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public SignatureKeyPair<SPSGroth15VerificationKey, SPSGroth15SigningKey> generateKeyPair(int numberOfMessages) {
        Zp zp = this.pp.getZp();
        if (numberOfMessages != this.pp.getNumberOfMessages()) {
            throw new IllegalArgumentException("Number of messages l has to be the same as in public parameters, but it is: " + numberOfMessages);
        }
        Zp.ZpElement exponentV = zp.getUniformlyRandomElement();
        SPSGroth15VerificationKey pk = new SPSGroth15VerificationKey();
        pk.setGroupElementV(this.pp.getOtherGroupGenerator().pow((Zn.ZnElement)exponentV));
        SPSGroth15SigningKey sk = new SPSGroth15SigningKey();
        sk.setExponentV(exponentV);
        return new SignatureKeyPair<SPSGroth15VerificationKey, SPSGroth15SigningKey>(pk, sk);
    }

    @Override
    public Signature sign(PlainText plainText, SigningKey secretKey) {
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        if (!(secretKey instanceof SPSGroth15SigningKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        SPSGroth15SigningKey sk = (SPSGroth15SigningKey)secretKey;
        if (messageBlock.length() != this.pp.getNumberOfMessages()) {
            throw new IllegalArgumentException("Not a valid block size for this scheme. Has to be " + this.pp.getNumberOfMessages() + ", but it is" + messageBlock.length());
        }
        if (messageBlock.length() <= 0) {
            throw new IllegalArgumentException("Number of messages l has to be greater 0, but it is: " + messageBlock.length());
        }
        Zp.ZpElement exponentR = this.pp.getZp().getUniformlyRandomUnit();
        GroupElement otherGroupElementR = this.pp.getOtherGroupGenerator().pow((Zn.ZnElement)exponentR);
        GroupElement plaintextGroupElementS = ((GroupElement)this.pp.getGroupElementsYi().get(0)).op((Element)this.pp.getPlaintextGroupGenerator().pow((Zn.ZnElement)sk.getExponentV())).pow((Zn.ZnElement)exponentR.inv());
        GroupElementVector plaintextGroupElementsTi = this.pp.getGroupElementsYi().pow((RingElement)sk.getExponentV()).op(messageBlock.map(pt -> ((GroupElementPlainText)pt).get())).pow((RingElement)exponentR.inv()).compute();
        GroupElement sigmaHatR = otherGroupElementR.compute();
        GroupElement sigmaS = plaintextGroupElementS.compute();
        return new SPSGroth15Signature(sigmaHatR, sigmaS, plaintextGroupElementsTi);
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        if (plainText instanceof GroupElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        if (!(signature instanceof SPSGroth15Signature)) {
            throw new IllegalArgumentException("Not a valid signature for this scheme");
        }
        if (!(publicKey instanceof SPSGroth15VerificationKey)) {
            throw new IllegalArgumentException("Not a valid public key for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        SPSGroth15VerificationKey pk = (SPSGroth15VerificationKey)publicKey;
        SPSGroth15Signature sigma = (SPSGroth15Signature)signature;
        GroupElement firstPPE = this.applyMap(sigma.getGroupElementSigma2S(), sigma.getGroupElementSigma1HatR());
        GroupElement firstPPERHS = this.applyMap((GroupElement)this.pp.getGroupElementsYi().get(0), this.pp.getOtherGroupGenerator()).op((Element)this.applyMap(this.pp.getPlaintextGroupGenerator(), pk.groupElementV));
        firstPPE.compute();
        firstPPERHS.compute();
        boolean secondPPE = ((GroupElementVector)sigma.getGroupElementSigma3Ti().map(ti -> this.applyMap((GroupElement)ti, sigma.getGroupElementSigma1HatR()), GroupElementVector::new)).equals((Object)((GroupElementVector)this.pp.getGroupElementsYi().map(yi -> this.applyMap((GroupElement)yi, pk.getGroupElementV()), GroupElementVector::new)).op(messageBlock.map(mi -> this.applyMap(((GroupElementPlainText)mi).get(), this.pp.getOtherGroupGenerator()))).compute());
        return firstPPE.equals(firstPPERHS) && secondPPE;
    }

    GroupElement applyMap(GroupElement plaintextGroupElement, GroupElement otherGroupElement) {
        if (this.pp.type == SPSGroth15PublicParametersGen.Groth15Type.type1) {
            return this.pp.getBilinearMap().apply(plaintextGroupElement, otherGroupElement);
        }
        return this.pp.getBilinearMap().apply(otherGroupElement, plaintextGroupElement);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    @Override
    public MessageBlock restorePlainText(Representation repr) {
        return new MessageBlock(repr, r -> new GroupElementPlainText((Representation)r, this.pp.getPlaintextGroupGenerator().getStructure()));
    }

    @Override
    public SPSGroth15Signature restoreSignature(Representation repr) {
        return new SPSGroth15Signature(repr, this.pp.getPlaintextGroupGenerator().getStructure(), this.pp.getOtherGroupGenerator().getStructure());
    }

    @Override
    public SPSGroth15SigningKey restoreSigningKey(Representation repr) {
        return new SPSGroth15SigningKey(repr, this.pp.getZp());
    }

    @Override
    public SPSGroth15VerificationKey restoreVerificationKey(Representation repr) {
        return new SPSGroth15VerificationKey(this.pp.getPlaintextGroupGenerator().getStructure(), this.pp.getOtherGroupGenerator().getStructure(), repr);
    }

    public SPSGroth15PublicParameters getPp() {
        return this.pp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pp == null ? 0 : this.pp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SPSGroth15SignatureScheme that = (SPSGroth15SignatureScheme)other;
        return Objects.equals(this.pp, that.pp);
    }

    @Override
    public MessageBlock mapToPlaintext(byte[] bytes, VerificationKey pk) {
        if (this.pp == null) {
            throw new NullPointerException("Number of messages is stored in public parameters but they are not set");
        }
        return this.mapToPlaintext(bytes, this.pp.getNumberOfMessages());
    }

    @Override
    public MessageBlock mapToPlaintext(byte[] bytes, SigningKey sk) {
        if (this.pp == null) {
            throw new NullPointerException("Number of messages is stored in public parameters but they are not set");
        }
        return this.mapToPlaintext(bytes, this.pp.getNumberOfMessages());
    }

    private MessageBlock mapToPlaintext(byte[] bytes, int messageBlockLength) {
        PlainText[] msgBlock = new GroupElementPlainText[messageBlockLength];
        msgBlock[0] = new GroupElementPlainText(this.pp.getPlaintextGroupGenerator().pow((Zn.ZnElement)this.pp.getZp().injectiveValueOf(bytes)));
        for (int i = 1; i < msgBlock.length; ++i) {
            msgBlock[i] = new GroupElementPlainText(this.pp.getPlaintextGroupGenerator());
        }
        return new MessageBlock(msgBlock);
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getPlaintextGroupGenerator().getStructure().size().bitLength() - 1) / 8;
    }
}

