/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.hashthensign;

import java.util.Objects;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.VariableOutputLengthHashFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class HashThenSign
implements SignatureScheme {
    @Represented
    private SignatureScheme encapsulatedScheme;
    @Represented
    private HashFunction hashFunction;

    public HashThenSign(HashFunction hashFunction, SignatureScheme signatureScheme) {
        if (hashFunction.getOutputLength() > signatureScheme.getMaxNumberOfBytesForMapToPlaintext()) {
            throw new IllegalArgumentException("The given hash function is incompatible with the given signature scheme! The output length is too large.");
        }
        this.hashFunction = hashFunction;
        this.encapsulatedScheme = signatureScheme;
    }

    public HashThenSign(SignatureScheme signatureScheme) {
        this.hashFunction = new VariableOutputLengthHashFunction(signatureScheme.getMaxNumberOfBytesForMapToPlaintext());
        this.encapsulatedScheme = signatureScheme;
    }

    public HashThenSign(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public Signature sign(ByteAccumulator plaintextBytes, SigningKey secretKey) {
        return this.sign(new ByteArrayImplementation(plaintextBytes.extractBytes()), secretKey);
    }

    @Override
    public Signature sign(PlainText plainText, SigningKey secretKey) {
        if (!(plainText instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        ByteArrayImplementation pt = (ByteArrayImplementation)plainText;
        byte[] hashedBytes = this.hashFunction.hash(pt.getData());
        PlainText hashedPlaintext = this.encapsulatedScheme.mapToPlaintext(hashedBytes, secretKey);
        return this.encapsulatedScheme.sign(hashedPlaintext, secretKey);
    }

    public Boolean verify(ByteAccumulator plaintextBytes, Signature signature, VerificationKey publicKey) {
        return this.verify(new ByteArrayImplementation(plaintextBytes.extractBytes()), signature, publicKey);
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        if (!(plainText instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        ByteArrayImplementation pt = (ByteArrayImplementation)plainText;
        byte[] hashedBytes = this.hashFunction.hash(pt.getData());
        PlainText hashedPlaintext = this.encapsulatedScheme.mapToPlaintext(hashedBytes, publicKey);
        return this.encapsulatedScheme.verify(hashedPlaintext, signature, publicKey);
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    @Override
    public Signature restoreSignature(Representation repr) {
        return this.encapsulatedScheme.restoreSignature(repr);
    }

    @Override
    public SigningKey restoreSigningKey(Representation repr) {
        return this.encapsulatedScheme.restoreSigningKey(repr);
    }

    @Override
    public VerificationKey restoreVerificationKey(Representation repr) {
        return this.encapsulatedScheme.restoreVerificationKey(repr);
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, VerificationKey pk) {
        return new ByteArrayImplementation(bytes);
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, SigningKey sk) {
        return new ByteArrayImplementation(bytes);
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return Integer.MAX_VALUE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.encapsulatedScheme == null ? 0 : this.encapsulatedScheme.hashCode());
        result = 31 * result + (this.hashFunction == null ? 0 : this.hashFunction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashThenSign other = (HashThenSign)obj;
        return Objects.equals(this.encapsulatedScheme, other.encapsulatedScheme) && Objects.equals(this.hashFunction, other.hashFunction);
    }
}

