/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.bbs;

import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class BBSBVerificationKey
implements VerificationKey {
    @Represented(restorer="G2")
    private GroupElement w;
    @Represented(restorer="[G2]")
    private GroupElement[] uiG2Elements;

    public BBSBVerificationKey() {
    }

    public BBSBVerificationKey(Representation repr, Group groupG2) {
        new ReprUtil((Object)this).register((RepresentationRestorer)groupG2, "G2").deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public GroupElement getW() {
        return this.w;
    }

    public void setW(GroupElement w) {
        this.w = w;
    }

    public GroupElement[] getUiG2Elements() {
        return this.uiG2Elements;
    }

    public void setUiG2Elements(GroupElement[] uiG2Elements) {
        this.uiG2Elements = uiG2Elements;
    }

    public int getNumberOfMessages() {
        return this.uiG2Elements.length - 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.uiG2Elements);
        result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BBSBVerificationKey other = (BBSBVerificationKey)obj;
        return Objects.equals(this.w, other.w) && Arrays.equals(this.uiG2Elements, other.uiG2Elements);
    }
}

