/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.bbs;

import org.cryptimeleon.craco.sig.bbs.BBSBPublicParameter;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularBilinearGroup;

public class BBSBKeyGen {
    private BBSBPublicParameter pp;
    private BilinearGroup group;

    public BBSBPublicParameter doKeyGen(int securityParameter) {
        return this.doKeyGen(securityParameter, false);
    }

    public BBSBPublicParameter doKeyGen(int securityParameter, boolean debugMode) {
        this.group = debugMode ? new DebugBilinearGroup(RandomGenerator.getRandomPrime((int)securityParameter), BilinearGroup.Type.TYPE_1) : new SupersingularBilinearGroup(securityParameter);
        return this.doKeyGen(this.group);
    }

    public BBSBPublicParameter doKeyGen(BilinearGroup group) {
        this.pp = new BBSBPublicParameter(group, group.getHashIntoZGroupExponent());
        this.pp.setG2(this.pp.getGroupG1().getUniformlyRandomElement());
        this.pp.setG1((GroupElement)this.pp.getGroupHom().apply((Object)this.pp.getG2()));
        return this.pp;
    }

    public BilinearGroup getGroup() {
        return this.group;
    }
}

