/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing.accessstructure;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.PolicyFact;
import org.cryptimeleon.craco.secretsharing.LinearSecretSharing;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.PolicyToTreeNodeConverter;
import org.cryptimeleon.craco.secretsharing.accessstructure.utils.TreeNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.AccessGrantedVisitor;
import org.cryptimeleon.craco.secretsharing.accessstructure.visitors.ToStringVisitor;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public abstract class AccessStructure
implements LinearSecretSharing<PolicyFact> {
    protected TreeNode thresholdTree;
    protected Zp field;
    protected HashMap<Integer, PolicyFact> shareReceivers;

    public AccessStructure(Policy policy, Zp field) {
        this.field = field;
        PolicyToTreeNodeConverter converter = new PolicyToTreeNodeConverter(policy);
        this.shareReceivers = converter.getShareReceiverMap();
        this.thresholdTree = converter.getTree();
    }

    @Override
    public boolean isQualified(Set<? extends PolicyFact> setOfShareReceivers) throws WrongAccessStructureException {
        Set<Integer> shares = this.getSharesOfReceivers(setOfShareReceivers);
        AccessGrantedVisitor visitor = new AccessGrantedVisitor(shares);
        this.thresholdTree.performVisitor(visitor);
        return (Boolean)visitor.getResultOfCurrentNode();
    }

    public String toString() {
        ToStringVisitor visitor = new ToStringVisitor();
        try {
            this.thresholdTree.performVisitor(visitor);
            return visitor.getResultOfCurrentNode();
        }
        catch (WrongAccessStructureException e) {
            return super.toString();
        }
    }

    @Override
    public Map<Integer, PolicyFact> getShareReceiverMap() {
        return new HashMap<Integer, PolicyFact>(this.shareReceivers);
    }

    @Override
    public Zp getSharedRing() {
        return this.field;
    }
}

