/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.secretsharing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cryptimeleon.craco.common.policies.Policy;
import org.cryptimeleon.craco.common.policies.PolicyFact;
import org.cryptimeleon.craco.common.policies.ThresholdPolicy;
import org.cryptimeleon.craco.secretsharing.InnerSecretSharingNode;
import org.cryptimeleon.craco.secretsharing.LeafSecretSharingNode;
import org.cryptimeleon.craco.secretsharing.LinearSecretSharing;
import org.cryptimeleon.craco.secretsharing.SecretSharingSchemeProvider;
import org.cryptimeleon.craco.secretsharing.SecretSharingTreeNode;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.NoSatisfyingSet;
import org.cryptimeleon.craco.secretsharing.accessstructure.exceptions.WrongAccessStructureException;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class ThresholdTreeSecretSharing
implements LinearSecretSharing<Policy>,
StandaloneRepresentable {
    @Represented
    private SecretSharingSchemeProvider lsssInstanceProvider;
    @Represented
    private Zp field;
    @Represented
    private ThresholdPolicy rootThresholdPolicy;
    private InnerSecretSharingNode secretSharingTree;
    private Map<Integer, Policy> shareReceiverMap = new LinkedHashMap<Integer, Policy>();

    public ThresholdTreeSecretSharing(ThresholdPolicy policy, Zp field, SecretSharingSchemeProvider lsssInstanceProvider) {
        this.lsssInstanceProvider = lsssInstanceProvider;
        this.field = field;
        if (policy instanceof PolicyFact) {
            policy = new ThresholdPolicy(1, policy);
        }
        this.rootThresholdPolicy = policy;
        this.secretSharingTree = (InnerSecretSharingNode)this.createTree(policy);
    }

    public ThresholdTreeSecretSharing(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
        this.secretSharingTree = (InnerSecretSharingNode)this.createTree(this.rootThresholdPolicy);
    }

    private SecretSharingTreeNode createTree(Policy policy) {
        if (policy instanceof PolicyFact) {
            int nextIndex = this.shareReceiverMap.size() + 1;
            this.shareReceiverMap.put(nextIndex, policy);
            return new LeafSecretSharingNode(policy);
        }
        if (policy instanceof ThresholdPolicy) {
            ThresholdPolicy thresholdPolicy = (ThresholdPolicy)policy;
            ArrayList<SecretSharingTreeNode> children = new ArrayList<SecretSharingTreeNode>(thresholdPolicy.getChildren().size());
            for (Policy child : thresholdPolicy.getChildren()) {
                children.add(this.createTree(child));
            }
            int numberOfShares = children.stream().mapToInt(SecretSharingTreeNode::getNumberOfShares).sum();
            return new InnerSecretSharingNode(children, numberOfShares, thresholdPolicy, this.lsssInstanceProvider.createLSSSInstance(thresholdPolicy, this.field));
        }
        throw new IllegalArgumentException(policy.getClass().getName() + " is not a supported policy type");
    }

    @Override
    public Map<Integer, Zp.ZpElement> getShares(Zp.ZpElement secret) throws WrongAccessStructureException {
        HashMap<Integer, Zp.ZpElement> shares = new HashMap<Integer, Zp.ZpElement>(this.secretSharingTree.getNumberOfShares());
        this.collectShares(this.secretSharingTree, secret, shares);
        return shares;
    }

    private void collectShares(SecretSharingTreeNode treeNode, Zp.ZpElement secret, Map<Integer, Zp.ZpElement> currentShares) {
        if (treeNode instanceof InnerSecretSharingNode) {
            InnerSecretSharingNode innerNode = (InnerSecretSharingNode)treeNode;
            Map<Integer, Zp.ZpElement> shares = innerNode.getLsss().getShares(secret);
            for (int i = 1; i <= innerNode.getNumberOfChildren(); ++i) {
                this.collectShares(innerNode.getChildren().get(i - 1), shares.get(i), currentShares);
            }
        } else if (treeNode instanceof LeafSecretSharingNode) {
            int index = currentShares.size() + 1;
            currentShares.put(index, secret);
        } else {
            throw new IllegalArgumentException(treeNode.getClass().getName() + " is not a supported SecretSharingTreeNode type");
        }
    }

    @Override
    public Map<Integer, Zp.ZpElement> getSolvingVector(Set<? extends Policy> setOfShareReceivers) throws NoSatisfyingSet, WrongAccessStructureException {
        HashSet<SecretSharingTreeNode> setOfQualifiedNodes = new HashSet<SecretSharingTreeNode>();
        Set<Integer> setOfShareReceiverIds = this.getSharesOfReceivers(setOfShareReceivers);
        if (!this.isQualifiedAndFindQualifiedNodes(setOfShareReceiverIds, setOfQualifiedNodes)) {
            throw new NoSatisfyingSet();
        }
        HashMap<Integer, Zp.ZpElement> childSolvingVector = new HashMap<Integer, Zp.ZpElement>(setOfShareReceivers.size());
        this.collectSolvingVector(this.secretSharingTree, childSolvingVector, setOfShareReceiverIds, setOfQualifiedNodes, this.field.getOneElement(), 0);
        return childSolvingVector;
    }

    private void collectSolvingVector(SecretSharingTreeNode node, Map<Integer, Zp.ZpElement> solvingVector, Set<Integer> setOfShareReceiverIds, Set<SecretSharingTreeNode> setOfQualifiedNodes, Zp.ZpElement factor, int shareIdOffset) {
        if (node instanceof LeafSecretSharingNode) {
            int possibleShareId = shareIdOffset + 1;
            if (setOfShareReceiverIds.contains(possibleShareId)) {
                solvingVector.put(possibleShareId, factor);
            }
        } else if (node instanceof InnerSecretSharingNode) {
            InnerSecretSharingNode innerNode = (InnerSecretSharingNode)node;
            List<SecretSharingTreeNode> innerChildren = innerNode.getChildren();
            Set qualifiedChildren = setOfQualifiedNodes.stream().filter(innerChildren::contains).map(SecretSharingTreeNode::getPolicy).collect(Collectors.toSet());
            Map<Integer, Zp.ZpElement> childSV = innerNode.getLsss().getSolvingVector(qualifiedChildren);
            for (int i = 1; i <= innerChildren.size(); ++i) {
                SecretSharingTreeNode innerChild = innerChildren.get(i - 1);
                if (childSV.containsKey(i)) {
                    this.collectSolvingVector(innerChild, solvingVector, setOfShareReceiverIds, setOfQualifiedNodes, factor.mul((Element)childSV.get(i)), shareIdOffset);
                }
                shareIdOffset += innerChild.getNumberOfShares();
            }
        } else {
            throw new IllegalArgumentException(node.getClass().getName() + " is not a supported SecretSharingTreeNode type");
        }
    }

    private Map<Integer, Zp.ZpElement> collectChildShares(InnerSecretSharingNode root, Map<Integer, Zp.ZpElement> shares, int shareIdOffset) {
        HashMap<Integer, Zp.ZpElement> childShares = new HashMap<Integer, Zp.ZpElement>();
        int offset = shareIdOffset;
        List<SecretSharingTreeNode> children = root.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            SecretSharingTreeNode node = children.get(i);
            if (node instanceof LeafSecretSharingNode) {
                int possibleShareId = offset + 1;
                if (shares.containsKey(possibleShareId)) {
                    int shareIdCorrection = 0;
                    for (int j = 0; j < i; ++j) {
                        SecretSharingTreeNode sibling = children.get(j);
                        shareIdCorrection += sibling.getNumberOfShares() - 1;
                    }
                    childShares.put(possibleShareId - shareIdCorrection, shares.get(possibleShareId));
                }
                ++offset;
                continue;
            }
            if (node instanceof InnerSecretSharingNode) {
                InnerSecretSharingNode innerNode = (InnerSecretSharingNode)node;
                try {
                    Zp.ZpElement innerSecret = this.reconstructInnerSecret(shares, offset, innerNode);
                    childShares.put(shareIdOffset + i + 1, innerSecret);
                }
                catch (NoSatisfyingSet noSatisfyingSet) {
                    // empty catch block
                }
                offset += innerNode.getNumberOfShares();
                continue;
            }
            throw new IllegalArgumentException(root.getClass().getName() + " is not a supported SecretSharingTreeNode type");
        }
        return childShares;
    }

    @Override
    public Map<Integer, Policy> getShareReceiverMap() {
        return this.shareReceiverMap;
    }

    @Override
    public boolean isQualified(Set<? extends Policy> setOfShareReceivers) throws WrongAccessStructureException {
        return this.isQualifiedAndFindQualifiedNodes(this.getSharesOfReceivers(setOfShareReceivers), new HashSet<SecretSharingTreeNode>());
    }

    private boolean isQualifiedAndFindQualifiedNodes(Set<Integer> setOfShareReceivers, Set<SecretSharingTreeNode> setOfQualifiedNodes) {
        this.findQualifiedNodes(this.secretSharingTree, setOfShareReceivers, 0, setOfQualifiedNodes);
        Set<Integer> qualifiedChildren = this.collectChildIds(this.secretSharingTree, setOfQualifiedNodes);
        return this.secretSharingTree.getLsss().isQualified((Collection<Integer>)qualifiedChildren);
    }

    @Override
    public Zp getSharedRing() {
        return this.field;
    }

    @Override
    public Map<Integer, Zp.ZpElement> completeShares(Zp.ZpElement secret, Map<Integer, Zp.ZpElement> partialShares) throws IllegalArgumentException {
        HashSet<SecretSharingTreeNode> setOfQualifiedNodes = new HashSet<SecretSharingTreeNode>();
        this.findQualifiedNodes(this.secretSharingTree, partialShares.keySet(), 0, setOfQualifiedNodes);
        HashMap<Integer, Zp.ZpElement> completedShares = new HashMap<Integer, Zp.ZpElement>(partialShares);
        this.completeSharesForChildren(this.secretSharingTree, secret, completedShares, 0, setOfQualifiedNodes);
        return completedShares;
    }

    private void findQualifiedNodes(InnerSecretSharingNode root, Set<Integer> shareReceivers, int shareIdOffset, Set<SecretSharingTreeNode> qualifiedNodes) {
        List<SecretSharingTreeNode> children = root.getChildren();
        for (SecretSharingTreeNode node : children) {
            if (node instanceof LeafSecretSharingNode) {
                int possibleShareId = shareIdOffset + 1;
                if (shareReceivers.contains(possibleShareId)) {
                    qualifiedNodes.add(node);
                }
                ++shareIdOffset;
                continue;
            }
            if (node instanceof InnerSecretSharingNode) {
                InnerSecretSharingNode innerInnerNode = (InnerSecretSharingNode)node;
                this.findQualifiedNodes(innerInnerNode, shareReceivers, shareIdOffset, qualifiedNodes);
                shareIdOffset += innerInnerNode.getNumberOfShares();
                Set<Integer> qualifiedChildren = this.collectChildIds(innerInnerNode, qualifiedNodes);
                if (!innerInnerNode.getLsss().isQualified((Collection<Integer>)qualifiedChildren)) continue;
                qualifiedNodes.add(node);
                continue;
            }
            throw new IllegalArgumentException(root.getClass().getName() + " is not a supported SecretSharingTreeNode type");
        }
    }

    private Set<Integer> collectChildIds(InnerSecretSharingNode parent, Set<SecretSharingTreeNode> nodes) {
        return nodes.stream().filter(parent.getChildren()::contains).map(child -> parent.getChildren().indexOf(child) + 1).collect(Collectors.toSet());
    }

    private void completeSharesForChildren(InnerSecretSharingNode root, Zp.ZpElement secret, Map<Integer, Zp.ZpElement> completedShares, int shareIdOffset, Set<SecretSharingTreeNode> setOfQualifiedNodes) {
        SecretSharingTreeNode node;
        int i;
        Set<Integer> qualifiedChildren = this.collectChildIds(root, setOfQualifiedNodes);
        Map<Integer, Zp.ZpElement> availableShares = new HashMap<Integer, Zp.ZpElement>();
        int offset = shareIdOffset;
        List<SecretSharingTreeNode> children = root.getChildren();
        for (i = 0; i < children.size(); ++i) {
            node = children.get(i);
            if (node instanceof LeafSecretSharingNode) {
                if (qualifiedChildren.contains(i + 1)) {
                    int possibleShareId = offset + 1;
                    if (!completedShares.containsKey(possibleShareId)) {
                        throw new WrongAccessStructureException("A leaf is marked as qualified but its share is not present");
                    }
                    availableShares.put(i + 1, completedShares.get(possibleShareId));
                }
                ++offset;
                continue;
            }
            if (node instanceof InnerSecretSharingNode) {
                InnerSecretSharingNode innerNode = (InnerSecretSharingNode)node;
                if (qualifiedChildren.contains(i + 1)) {
                    Zp.ZpElement innerSecret = this.reconstructInnerSecret(completedShares, offset, innerNode);
                    availableShares.put(i + 1, innerSecret);
                }
                offset += innerNode.getNumberOfShares();
                continue;
            }
            throw new IllegalArgumentException(root.getClass().getName() + " is not a supported SecretSharingTreeNode type");
        }
        availableShares = root.getLsss().completeShares(secret, availableShares);
        offset = shareIdOffset;
        for (i = 0; i < children.size(); ++i) {
            node = children.get(i);
            if (node instanceof LeafSecretSharingNode) {
                if (!qualifiedChildren.contains(i + 1)) {
                    int possibleShareId = offset + 1;
                    if (completedShares.containsKey(possibleShareId)) {
                        throw new WrongAccessStructureException("A leaf is marked as not qualified but its share is present");
                    }
                    completedShares.put(possibleShareId, availableShares.get(i + 1));
                }
                ++offset;
                continue;
            }
            if (node instanceof InnerSecretSharingNode) {
                InnerSecretSharingNode innerNode = (InnerSecretSharingNode)node;
                Zp.ZpElement partialSecret = availableShares.get(i + 1);
                this.completeSharesForChildren(innerNode, partialSecret, completedShares, offset, setOfQualifiedNodes);
                offset += innerNode.getNumberOfShares();
                continue;
            }
            throw new IllegalArgumentException(root.getClass().getName() + " is not a supported SecretSharingTreeNode type");
        }
    }

    private Zp.ZpElement reconstructInnerSecret(Map<Integer, Zp.ZpElement> shares, int shareIdOffset, InnerSecretSharingNode innerNode) {
        Map<Integer, Zp.ZpElement> childInnerNodeShares = this.collectChildShares(innerNode, shares, shareIdOffset);
        childInnerNodeShares = childInnerNodeShares.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey() - shareIdOffset, Map.Entry::getValue));
        if (!innerNode.getLsss().isQualified((Collection<Integer>)childInnerNodeShares.keySet())) {
            throw new NoSatisfyingSet();
        }
        return innerNode.getLsss().reconstruct(childInnerNodeShares);
    }

    @Override
    public boolean checkShareConsistency(Zp.ZpElement secret, Map<Integer, Zp.ZpElement> shares) {
        if (shares.size() != this.getShareReceiverMap().size()) {
            throw new IllegalArgumentException("The given set of shares is not a complete set!");
        }
        return this.checkShareConsistencyForChildren(this.secretSharingTree, secret, shares, 0);
    }

    private boolean checkShareConsistencyForChildren(InnerSecretSharingNode root, Zp.ZpElement secret, Map<Integer, Zp.ZpElement> shares, int shareIdOffset) {
        HashMap<Integer, Zp.ZpElement> childShares = new HashMap<Integer, Zp.ZpElement>();
        int offset = shareIdOffset;
        List<SecretSharingTreeNode> children = root.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            SecretSharingTreeNode node = children.get(i);
            if (node instanceof LeafSecretSharingNode) {
                int actualShareId = offset + 1;
                childShares.put(i + 1, shares.get(actualShareId));
                ++offset;
                continue;
            }
            if (node instanceof InnerSecretSharingNode) {
                InnerSecretSharingNode innerNode = (InnerSecretSharingNode)node;
                Map<Integer, Zp.ZpElement> childInnerNodeShares = this.collectChildShares(innerNode, shares, offset);
                int currentOffset = offset;
                childInnerNodeShares = childInnerNodeShares.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey() - currentOffset, Map.Entry::getValue));
                Zp.ZpElement innerSecret = innerNode.getLsss().reconstruct(childInnerNodeShares);
                childShares.put(i + 1, innerSecret);
                if (!this.checkShareConsistencyForChildren(innerNode, innerSecret, shares, offset)) {
                    return false;
                }
                offset += innerNode.getNumberOfShares();
                continue;
            }
            throw new IllegalArgumentException(root.getClass().getName() + " is not a supported SecretSharingTreeNode type");
        }
        return root.getLsss().checkShareConsistency(secret, childShares);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThresholdTreeSecretSharing that = (ThresholdTreeSecretSharing)o;
        boolean equalsLsss = Objects.equals(this.lsssInstanceProvider, that.lsssInstanceProvider);
        boolean equalsField = Objects.equals(this.field, that.field);
        boolean equalsPolicy = Objects.equals(this.rootThresholdPolicy, that.rootThresholdPolicy);
        boolean equalsTree = Objects.equals(this.secretSharingTree, that.secretSharingTree);
        boolean equalsMap = Objects.equals(this.shareReceiverMap, that.shareReceiverMap);
        return Objects.equals(this.lsssInstanceProvider, that.lsssInstanceProvider) && Objects.equals(this.field, that.field) && Objects.equals(this.rootThresholdPolicy, that.rootThresholdPolicy) && Objects.equals(this.secretSharingTree, that.secretSharingTree) && Objects.equals(this.shareReceiverMap, that.shareReceiverMap);
    }

    public int hashCode() {
        return Objects.hash(this.lsssInstanceProvider, this.field, this.rootThresholdPolicy, this.secretSharingTree, this.shareReceiverMap);
    }
}

