/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariable;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableAssignment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableValue;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;

public class SchnorrVariableValueList
implements SchnorrVariableAssignment,
AnnouncementSecret,
Response {
    private final LinkedHashMap<SchnorrVariable, SchnorrVariableValue> variableValues;

    public SchnorrVariableValueList(List<? extends SchnorrVariableValue> variableValues) {
        this.variableValues = new LinkedHashMap();
        for (SchnorrVariableValue schnorrVariableValue : variableValues) {
            this.variableValues.put(schnorrVariableValue.getVariable(), schnorrVariableValue);
        }
    }

    public SchnorrVariableValueList(List<? extends SchnorrVariable> variables, Representation repr) {
        int i = 0;
        this.variableValues = new LinkedHashMap();
        for (SchnorrVariable schnorrVariable : variables) {
            SchnorrVariableValue val = schnorrVariable.restoreValue(repr.list().get(i++));
            this.variableValues.put(val.getVariable(), val);
        }
    }

    private SchnorrVariableValueList(LinkedHashMap<SchnorrVariable, SchnorrVariableValue> variableValues) {
        this.variableValues = variableValues;
    }

    public SchnorrVariableValueList(Map<String, SchnorrVariableValue> nameValueMap) {
        this(nameValueMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public SchnorrVariableValue getValue(SchnorrVariable variable) {
        return this.variableValues.get(variable);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        this.variableValues.forEach((k, v) -> accumulator.append((UniqueByteRepresentable)v));
        return accumulator;
    }

    public Representation getRepresentation() {
        ListRepresentation repr = new ListRepresentation();
        this.variableValues.values().stream().map(Representable::getRepresentation).forEachOrdered(arg_0 -> ((ListRepresentation)repr).add(arg_0));
        return repr;
    }

    public SchnorrVariableValueList map(BiFunction<SchnorrVariable, SchnorrVariableValue, SchnorrVariableValue> mapper) {
        LinkedHashMap<SchnorrVariable, SchnorrVariableValue> newValues = new LinkedHashMap<SchnorrVariable, SchnorrVariableValue>();
        this.variableValues.forEach((k, v) -> {
            SchnorrVariableValue cfr_ignored_0 = (SchnorrVariableValue)newValues.put((SchnorrVariable)k, (SchnorrVariableValue)mapper.apply((SchnorrVariable)k, (SchnorrVariableValue)v));
        });
        return new SchnorrVariableValueList(newValues);
    }
}

