/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class SetMembershipPublicParameters
implements Representable {
    BilinearGroup bilinearGroup;
    @Represented(restorer="G1")
    GroupElement g1;
    @Represented(restorer="G2")
    GroupElement g2;
    @Represented(restorer="G2")
    GroupElement pk;
    @Represented(restorer="int -> G1")
    HashMap<BigInteger, GroupElement> signatures;
    GroupElement egg;

    public SetMembershipPublicParameters(BilinearGroup bilinearGroup, GroupElement g1, GroupElement g2, GroupElement pk, HashMap<BigInteger, GroupElement> signatures) {
        this.bilinearGroup = bilinearGroup;
        this.g1 = g1;
        this.g2 = g2;
        this.pk = pk;
        this.signatures = signatures;
        this.egg = bilinearGroup.getBilinearMap().apply(g1, g2);
    }

    public SetMembershipPublicParameters(BilinearGroup group, Representation repr) {
        this.bilinearGroup = group;
        new ReprUtil((Object)this).register(group).deserialize(repr);
        this.egg = this.bilinearGroup.getBilinearMap().apply(this.g1, this.g2);
    }

    public static SetMembershipPublicParameters generate(BilinearGroup group, Collection<BigInteger> set) {
        GroupElement g1 = group.getG1().getUniformlyRandomNonNeutral();
        GroupElement g2 = group.getG2().getUniformlyRandomNonNeutral();
        Zn.ZnElement sk = group.getG1().getUniformlyRandomExponent();
        GroupElement pk = g2.pow(sk);
        HashMap<BigInteger, GroupElement> signatures = new HashMap<BigInteger, GroupElement>();
        for (BigInteger i : set) {
            signatures.put(i, g1.pow(sk.add((Element)group.getZn().valueOf(i)).inv()));
            if (i.compareTo(group.getG1().size()) <= 0) continue;
            throw new IllegalArgumentException("Set contains too large a number.");
        }
        return new SetMembershipPublicParameters(group, g1, g2, pk, signatures);
    }

    public static SetMembershipPublicParameters generate(BilinearGroup group, BigInteger ... set) {
        return SetMembershipPublicParameters.generate(group, Arrays.asList(set));
    }

    public static SetMembershipPublicParameters generate(BilinearGroup group, int ... set) {
        return SetMembershipPublicParameters.generate(group, (BigInteger[])Arrays.stream(set).mapToObj(BigInteger::valueOf).toArray(BigInteger[]::new));
    }

    public static SetMembershipPublicParameters generateInterval(BilinearGroup group, int leftBoundInclusive, int rightBoundExclusive) {
        return SetMembershipPublicParameters.generate(group, IntStream.range(leftBoundInclusive, rightBoundExclusive).mapToObj(BigInteger::valueOf).collect(Collectors.toSet()));
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public Zn getZn() {
        return this.g1.getStructure().getZn();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetMembershipPublicParameters that = (SetMembershipPublicParameters)o;
        return Objects.equals(this.bilinearGroup, that.bilinearGroup) && Objects.equals(this.g1, that.g1) && Objects.equals(this.g2, that.g2) && Objects.equals(this.pk, that.pk) && Objects.equals(this.signatures, that.signatures) && Objects.equals(this.egg, that.egg);
    }

    public int hashCode() {
        return Objects.hash(this.bilinearGroup, this.g1, this.g2, this.pk, this.signatures, this.egg);
    }
}

