/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.Structure;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public interface SendFirstValue
extends Representable,
UniqueByteRepresentable {
    public static final SendFirstValue EMPTY = new EmptySendFirstValue();

    public static class AlgebraicSendFirstValue
    implements SendFirstValue {
        @UniqueByteRepresented
        private final List<Element> elements = new ArrayList<Element>();

        public AlgebraicSendFirstValue(Element ... values) {
            this.elements.addAll(Arrays.asList(values));
        }

        public AlgebraicSendFirstValue(Representation repr, Structure ... structures) {
            for (int i = 0; i < structures.length; ++i) {
                this.elements.add(structures[i].restoreElement(repr.list().get(i)));
            }
        }

        public Element getElement(int i) {
            return this.elements.get(i);
        }

        public GroupElement getGroupElement(int i) {
            return (GroupElement)this.getElement(i);
        }

        public Zn.ZnElement getZnElement(int i) {
            return (Zn.ZnElement)this.getElement(i);
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
            return accumulator;
        }

        public Representation getRepresentation() {
            ListRepresentation repr = new ListRepresentation();
            this.elements.forEach(elem -> repr.add(elem.getRepresentation()));
            return repr;
        }
    }

    public static class EmptySendFirstValue
    implements SendFirstValue {
        private EmptySendFirstValue() {
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            return accumulator;
        }

        public Representation getRepresentation() {
            return null;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof EmptySendFirstValue;
        }
    }
}

