/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr;

import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableAssignment;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representation;

public interface SchnorrFragment {
    public AnnouncementSecret generateAnnouncementSecret(SchnorrVariableAssignment var1);

    public Announcement generateAnnouncement(SchnorrVariableAssignment var1, AnnouncementSecret var2, SchnorrVariableAssignment var3);

    public Response generateResponse(SchnorrVariableAssignment var1, AnnouncementSecret var2, ZnChallenge var3);

    public BooleanExpression checkTranscript(Announcement var1, ZnChallenge var2, Response var3, SchnorrVariableAssignment var4);

    public SigmaProtocolTranscript generateSimulatedTranscript(ZnChallenge var1, SchnorrVariableAssignment var2);

    default public Representation compressTranscript(Announcement announcement, ZnChallenge challenge, Response response, SchnorrVariableAssignment externalResponse) {
        ListRepresentation repr = new ListRepresentation();
        repr.add(announcement.getRepresentation());
        repr.add(response.getRepresentation());
        return repr;
    }

    default public SigmaProtocolTranscript decompressTranscript(Representation compressedTranscript, ZnChallenge challenge, SchnorrVariableAssignment externalResponse) throws IllegalArgumentException {
        Announcement announcement = this.restoreAnnouncement(compressedTranscript.list().get(0));
        Response response = this.restoreResponse(announcement, compressedTranscript.list().get(1));
        return new SigmaProtocolTranscript(announcement, challenge, response);
    }

    public Announcement restoreAnnouncement(Representation var1);

    public Response restoreResponse(Announcement var1, Representation var2);

    default public void debugFragment(SchnorrVariableAssignment externalWitness, ZnChallengeSpace challengeSpace) {
        SchnorrVariableAssignment externalResponse;
        Response response;
        ZnChallenge challenge;
        SchnorrVariableAssignment externalRandom;
        AnnouncementSecret announcementSecret = this.generateAnnouncementSecret(externalWitness);
        Announcement announcement = this.generateAnnouncement(externalWitness, announcementSecret, externalRandom = externalWitness);
        if (!this.checkTranscript(announcement, challenge = challengeSpace.generateRandomChallenge(), response = this.generateResponse(externalWitness, announcementSecret, challenge), externalResponse = externalWitness.evalLinear(challenge.getChallenge(), externalRandom)).evaluate().booleanValue()) {
            throw new RuntimeException(this.getClass().getName() + " proof fails.");
        }
    }
}

