/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.fiatshamir;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.fiatshamir.FiatShamirProof;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.impl.ByteArrayAccumulator;
import org.cryptimeleon.math.serialization.Representation;

public class FiatShamirProofSystem {
    private final SigmaProtocol protocol;

    public FiatShamirProofSystem(SigmaProtocol protocol) {
        this.protocol = protocol;
    }

    public FiatShamirProof createProof(CommonInput commonInput, SecretInput secretInput, byte[] additionalData) {
        AnnouncementSecret announcementSecret = this.protocol.generateAnnouncementSecret(commonInput, secretInput);
        Announcement announcement = this.protocol.generateAnnouncement(commonInput, secretInput, announcementSecret);
        Challenge challenge = this.computeChallengeForAnnouncement(commonInput, announcement, additionalData);
        Response response = this.protocol.generateResponse(commonInput, secretInput, announcement, announcementSecret, challenge);
        return new FiatShamirProof(this.protocol.compressTranscript(commonInput, new SigmaProtocolTranscript(announcement, challenge, response)), challenge);
    }

    public FiatShamirProof createProof(CommonInput commonInput, SecretInput secretInput) {
        return this.createProof(commonInput, secretInput, new byte[0]);
    }

    public boolean checkProof(CommonInput commonInput, FiatShamirProof proof, byte[] additionalData) {
        SigmaProtocolTranscript transcript = this.protocol.decompressTranscript(commonInput, proof.challenge, proof.compressedTranscript);
        return this.computeChallengeForAnnouncement(commonInput, transcript.getAnnouncement(), additionalData).equals(transcript.getChallenge());
    }

    public boolean checkProof(CommonInput commonInput, FiatShamirProof proof) {
        return this.checkProof(commonInput, proof, new byte[0]);
    }

    private Challenge computeChallengeForAnnouncement(CommonInput commonInput, Announcement announcement, byte[] additionalData) {
        ByteArrayAccumulator acc = new ByteArrayAccumulator();
        acc.escapeAndSeparate((UniqueByteRepresentable)announcement);
        acc.append(additionalData);
        return this.protocol.getChallengeSpace(commonInput).hashIntoChallengeSpace(acc.extractBytes());
    }

    public FiatShamirProof restoreProof(CommonInput commonInput, Representation repr) {
        return new FiatShamirProof(repr.obj().get("transcript"), this.protocol.restoreChallenge(commonInput, repr.obj().get("challenge")));
    }
}

