/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.damgardtechnique;

import java.util.Objects;
import org.cryptimeleon.craco.commitment.OpenValue;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;

class DamgardResponse
implements Response {
    private final Response innerResponse;
    private final Announcement innerAnnouncement;
    private final Representation compressedTranscript;
    private final OpenValue openValue;

    public DamgardResponse(Response innerResponse, Announcement innerAnnouncement, OpenValue openValue, Representation compressedTranscript) {
        this.innerResponse = innerResponse;
        this.innerAnnouncement = innerAnnouncement;
        this.openValue = openValue;
        this.compressedTranscript = compressedTranscript;
    }

    public Response getInnerResponse() {
        return this.innerResponse;
    }

    public Announcement getInnerAnnouncement() {
        return this.innerAnnouncement;
    }

    public OpenValue getOpenValue() {
        return this.openValue;
    }

    public Representation getRepresentation() {
        ObjectRepresentation repr = new ObjectRepresentation();
        repr.put("compressedTranscript", this.compressedTranscript);
        repr.put("openValue", this.openValue.getRepresentation());
        return repr;
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator byteAccumulator) {
        byteAccumulator.escapeAndSeparate((UniqueByteRepresentable)this.innerResponse);
        byteAccumulator.escapeAndSeparate((UniqueByteRepresentable)this.innerAnnouncement);
        byteAccumulator.escapeAndAppend((UniqueByteRepresentable)this.openValue);
        return byteAccumulator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DamgardResponse that = (DamgardResponse)o;
        return this.innerResponse.equals(that.innerResponse) && this.innerAnnouncement.equals(that.innerAnnouncement) && this.openValue.equals(that.openValue);
    }

    public int hashCode() {
        return Objects.hash(this.innerResponse, this.innerAnnouncement, this.openValue);
    }
}

