/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.common.plaintexts;

import java.util.Objects;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;

public class RingElementPlainText
implements PlainText {
    private final RingElement element;

    public RingElementPlainText(RingElement element) {
        this.element = element;
    }

    public RingElementPlainText(Representation repr) {
        Ring ring = (Ring)repr.obj().get("ring").repr().recreateRepresentable();
        this.element = ring.restoreElement(repr.obj().get("elem"));
    }

    public RingElement getRingElement() {
        return this.element;
    }

    public Representation getRepresentation() {
        ObjectRepresentation result = new ObjectRepresentation();
        result.put("elem", this.element.getRepresentation());
        result.put("ring", (Representation)new RepresentableRepresentation((Representable)this.element.getStructure()));
        return result;
    }

    public int hashCode() {
        return Objects.hashCode(this.element);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RingElementPlainText other = (RingElementPlainText)obj;
        return Objects.equals(this.element, other.element);
    }

    public String toString() {
        return this.element.toString();
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return this.element.updateAccumulator(accumulator);
    }
}

