/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.common.attributes;

import java.util.Collection;
import org.cryptimeleon.craco.common.attributes.Attribute;
import org.cryptimeleon.craco.common.policies.PolicyFact;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StringRepresentation;

public class StringAttribute
implements Attribute {
    private String attribute;

    public StringAttribute(String name) {
        this.attribute = name;
    }

    public StringAttribute(Representation repr) {
        this.attribute = repr.str().get();
    }

    public String getAttributeName() {
        return this.attribute;
    }

    public Representation getRepresentation() {
        return new StringRepresentation(this.attribute);
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringAttribute other = (StringAttribute)obj;
        return !(this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute));
    }

    public String toString() {
        return this.attribute;
    }

    @Override
    public boolean isFulfilled(Collection<? extends PolicyFact> facts) {
        return facts.contains(this);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        accumulator.escapeAndAppend(this.attribute);
        return accumulator;
    }
}

