/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.common.attributes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cryptimeleon.craco.common.attributes.Attribute;
import org.cryptimeleon.craco.common.predicate.CiphertextIndex;
import org.cryptimeleon.craco.common.predicate.KeyIndex;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;

public class SetOfAttributes
implements KeyIndex,
CiphertextIndex,
Set<Attribute>,
UniqueByteRepresentable {
    @UniqueByteRepresented
    private Set<Attribute> attributes = new HashSet<Attribute>();

    public SetOfAttributes() {
    }

    public SetOfAttributes(Collection<? extends Attribute> attributes) {
        this.attributes.addAll(attributes);
    }

    public SetOfAttributes(Attribute ... attributes) {
        for (Attribute a : attributes) {
            this.attributes.add(a);
        }
    }

    public SetOfAttributes(Representation repr) {
        repr.list().forEach(r -> this.attributes.add((Attribute)r.repr().recreateRepresentable()));
    }

    public Representation getRepresentation() {
        ListRepresentation result = new ListRepresentation();
        this.attributes.stream().map(attr -> new RepresentableRepresentation((Representable)attr)).forEach(arg_0 -> ((ListRepresentation)result).put(arg_0));
        return result;
    }

    @Override
    public boolean add(Attribute m) {
        return this.attributes.add(m);
    }

    @Override
    public boolean addAll(Collection<? extends Attribute> c) {
        return this.attributes.addAll(c);
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.attributes.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.attributes.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.attributes.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.attributes.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.attributes.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.attributes.retainAll(c);
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public Object[] toArray() {
        return this.attributes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.attributes.toArray(a);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetOfAttributes other = (SetOfAttributes)obj;
        if (this.attributes == null) {
            if (other.attributes != null) {
                return false;
            }
        } else {
            if (!this.attributes.containsAll(other.attributes)) {
                return false;
            }
            if (!other.attributes.containsAll(this.attributes)) {
                return false;
            }
        }
        return true;
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (Attribute a : this.attributes) {
            builder.append(a.toString());
            builder.append(", ");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }
}

