/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.commitment.pedersen;

import java.util.Objects;
import org.cryptimeleon.craco.commitment.OpenValue;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class PedersenOpenValue
implements OpenValue {
    private final Zn.ZnElement randomness;

    public PedersenOpenValue(Zn.ZnElement randomness) {
        this.randomness = randomness;
    }

    public Zn.ZnElement getRandomValue() {
        return this.randomness;
    }

    public Representation getRepresentation() {
        return this.randomness.getRepresentation();
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator byteAccumulator) {
        byteAccumulator.append((UniqueByteRepresentable)this.randomness);
        return byteAccumulator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PedersenOpenValue that = (PedersenOpenValue)o;
        return this.randomness.equals((Object)that.randomness);
    }

    public int hashCode() {
        return Objects.hash(this.randomness);
    }
}

