/*
 * Decompiled with CFR 0.152.
 */
package org.creekservice.internal.platform.resource;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.creekservice.api.base.type.CodeLocation;
import org.creekservice.api.platform.metadata.AggregateDescriptor;
import org.creekservice.api.platform.metadata.ComponentDescriptor;
import org.creekservice.api.platform.metadata.OwnedResource;
import org.creekservice.api.platform.metadata.ResourceDescriptor;
import org.creekservice.api.platform.metadata.ServiceDescriptor;
import org.creekservice.api.platform.metadata.SharedResource;
import org.creekservice.api.platform.metadata.UnownedResource;

public final class ComponentValidator {
    private static final Pattern CTRL_CHAR = Pattern.compile("\\p{Cntrl}");

    public void validate(ComponentDescriptor ... components) {
        Arrays.stream(components).forEach(this::validateComponent);
    }

    private void validateComponent(ComponentDescriptor component) {
        this.validateComponentName(component);
        boolean isAggregate = component instanceof AggregateDescriptor;
        boolean isService = component instanceof ServiceDescriptor;
        if (isAggregate && isService) {
            throw new InvalidDescriptorException("descriptor is both aggregate and service descriptor", component);
        }
        if (!isAggregate && !isService) {
            throw new InvalidDescriptorException("descriptor is neither aggregate and service descriptor", component);
        }
        if (component instanceof AggregateDescriptor) {
            this.validateAggregate((AggregateDescriptor)component);
        } else {
            this.validateService((ServiceDescriptor)component);
        }
        this.validateComponentResources(component);
    }

    private void validateComponentName(ComponentDescriptor component) {
        if (component.name() == null || component.name().isBlank()) {
            throw new InvalidDescriptorException("name can not be null or blank", component, false);
        }
        if (CTRL_CHAR.matcher(component.name()).find()) {
            throw new InvalidDescriptorException("name can not contain control characters", component);
        }
    }

    private void validateComponentResources(ComponentDescriptor component) {
        this.validateResourcesMethod(component);
        component.resources().forEach(r -> this.validateResource((ResourceDescriptor)r, component));
    }

    private void validateAggregate(AggregateDescriptor component) {
        if (!component.internals().isEmpty()) {
            throw new InvalidDescriptorException("Aggregate should not expose internal resources. internals: " + component.internals(), (ComponentDescriptor)component);
        }
        List notOwned = component.resources().filter(r -> !(r instanceof OwnedResource)).collect(Collectors.toList());
        if (!notOwned.isEmpty()) {
            throw new InvalidDescriptorException("Aggregate should only expose OwnedResource. not_owned: " + notOwned, (ComponentDescriptor)component);
        }
    }

    private void validateService(ServiceDescriptor component) {
        if (component.dockerImage() == null || component.dockerImage().isBlank()) {
            throw new InvalidDescriptorException("dockerImage can not be null or blank", (ComponentDescriptor)component);
        }
        if (component.testEnvironment() == null) {
            throw new InvalidDescriptorException("testEnvironment can not be null", (ComponentDescriptor)component);
        }
    }

    private void validateResourcesMethod(ComponentDescriptor component) {
        try {
            Method m = component.getClass().getMethod("resources", new Class[0]);
            if (!m.getDeclaringClass().equals(ComponentDescriptor.class)) {
                throw new InvalidDescriptorException("should not override resources() method", component);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("no resources method", e);
        }
    }

    private void validateResource(ResourceDescriptor resource, ComponentDescriptor component) {
        if (resource == null) {
            throw new InvalidDescriptorException("contains null resource", component);
        }
        if (resource.id() == null) {
            throw new InvalidDescriptorException("null resource id, resource_type: " + resource.getClass().getSimpleName(), component);
        }
        List initialisation = ComponentValidator.types(resource.getClass()).filter(ComponentValidator::isResourceInitializationMarkerInterface).map(Class::getSimpleName).distinct().sorted().collect(Collectors.toList());
        if (initialisation.size() > 1) {
            throw new InvalidDescriptorException("resource can implement at-most one ResourceInitialization marker interface, but was: " + initialisation, resource, component);
        }
    }

    private static boolean isResourceInitializationMarkerInterface(Class<?> type) {
        return type == OwnedResource.class || type == UnownedResource.class || type == SharedResource.class;
    }

    private static Stream<Class<?>> types(Class<?> type) {
        Class<?> superclass = type.getSuperclass();
        Stream<Class<?>> types = superclass == null ? Stream.of(new Class[0]) : ComponentValidator.types(superclass);
        Stream interfaces = Arrays.stream(type.getInterfaces()).flatMap(ComponentValidator::types);
        return Stream.concat(Stream.of(type), Stream.concat(types, interfaces));
    }

    private static final class InvalidDescriptorException
    extends RuntimeException {
        InvalidDescriptorException(String msg, ComponentDescriptor component) {
            this(msg, component, true);
        }

        InvalidDescriptorException(String msg, ResourceDescriptor resource, ComponentDescriptor component) {
            this(msg + ", resource: " + resource.id(), component, true);
        }

        InvalidDescriptorException(String msg, ComponentDescriptor component, boolean useComponentName) {
            super(msg + ", component: " + (useComponentName ? component.name() : component.toString()) + " (" + CodeLocation.codeLocation((Object)component) + ")");
        }
    }
}

