/*
 * Decompiled with CFR 0.152.
 */
package org.creekservice.internal.observability.logging.structured;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.creekservice.api.observability.logging.structured.Level;
import org.creekservice.api.observability.logging.structured.LogEntryCustomizer;
import org.creekservice.api.observability.logging.structured.StructuredLogger;
import org.creekservice.internal.observability.logging.structured.DefaultLogEntryCustomizer;
import org.creekservice.internal.observability.logging.structured.JsonLogEntryFormatter;
import org.creekservice.internal.observability.logging.structured.LogEntryFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Slf4jStructuredLogger
implements StructuredLogger {
    private static final Slf4JLLevel[] SLF4J_LEVELS = new Slf4JLLevel[]{new Slf4JLLevel(Logger::isTraceEnabled, Logger::trace), new Slf4JLLevel(Logger::isDebugEnabled, Logger::debug), new Slf4JLLevel(Logger::isInfoEnabled, Logger::info), new Slf4JLLevel(Logger::isWarnEnabled, Logger::warn), new Slf4JLLevel(Logger::isErrorEnabled, Logger::error)};
    private final Logger logger;
    private final Optional<String> rootNs;
    private final Function<String, DefaultLogEntryCustomizer> customizerFactory;
    private final LogEntryFormatter formatter;

    public Slf4jStructuredLogger(Class<?> clazz, Optional<String> rootNs) {
        this(LoggerFactory.getLogger(clazz), rootNs, DefaultLogEntryCustomizer::create, new JsonLogEntryFormatter());
    }

    Slf4jStructuredLogger(Logger logger, Optional<String> rootNs, Function<String, DefaultLogEntryCustomizer> customizerFactory, LogEntryFormatter formatter) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.rootNs = Objects.requireNonNull(rootNs, "rootNs");
        this.customizerFactory = Objects.requireNonNull(customizerFactory, "customizerFactory");
        this.formatter = Objects.requireNonNull(formatter, "formatter");
    }

    @Override
    public void log(Level level, String message, Consumer<LogEntryCustomizer> customizeConsumer) {
        Slf4JLLevel slf4jLevel = SLF4J_LEVELS[level.ordinal()];
        if (slf4jLevel.disabled(this.logger)) {
            return;
        }
        DefaultLogEntryCustomizer customizer = this.customizerFactory.apply(message);
        customizeConsumer.accept(this.rootNs.map(customizer::ns).orElse(customizer));
        slf4jLevel.log(this.logger, this.formatter.format(customizer.build()), customizer.throwable().orElse(null));
    }

    private static final class Slf4JLLevel {
        final EnabledMethod enabledMethod;
        final LogMethod logMethod;

        Slf4JLLevel(EnabledMethod enabledMethod, LogMethod logMethod) {
            this.enabledMethod = Objects.requireNonNull(enabledMethod, "enabledMethod");
            this.logMethod = Objects.requireNonNull(logMethod, "logMethod");
        }

        boolean disabled(Logger logger) {
            return !this.enabledMethod.enabled(logger);
        }

        void log(Logger logger, String message, Throwable throwable) {
            this.logMethod.log(logger, message, throwable);
        }
    }

    private static interface LogMethod {
        public void log(Logger var1, String var2, Throwable var3);
    }

    private static interface EnabledMethod {
        public boolean enabled(Logger var1);
    }
}

