/*
 * Decompiled with CFR 0.152.
 */
package org.creekservice.internal.observability.logging.structured;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.creekservice.api.base.type.config.SystemProperties;
import org.creekservice.api.base.type.json.Json;
import org.creekservice.internal.observability.logging.structured.LogEntryFormatter;

final class JsonLogEntryFormatter
implements LogEntryFormatter {
    public static final String MAX_DEPTH_PROP = "org.creekservice.observability.logging.structured.depth.max";
    static int maxDepth = -1;
    private static final char DOUBLE_QUOTE = '\"';
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final char OBJECT_START = '{';
    private static final char OBJECT_END = '}';
    private static final char ARRAY_START = '[';
    private static final char ARRAY_END = ']';
    private static final List<Handler> HANDLERS = List.of(new NullHandler(), new SimpleHandler<String>(String.class, JsonLogEntryFormatter::formatString), new SimpleHandler<BigDecimal>(BigDecimal.class, StringBuilder::append), new SimpleHandler<Double>(Double.class, (sb, o) -> sb.append((double)o)), new SimpleHandler<Float>(Float.class, (sb, o) -> sb.append(o.floatValue())), new SimpleHandler<Byte>(Byte.class, (sb, o) -> sb.append(o.byteValue())), new SimpleHandler<Short>(Short.class, (sb, o) -> sb.append(o.shortValue())), new SimpleHandler<Integer>(Integer.class, (sb, o) -> sb.append((int)o)), new SimpleHandler<Long>(Long.class, (sb, o) -> sb.append((long)o)), new SimpleHandler<Number>(Number.class, JsonLogEntryFormatter::formatNumber), new SimpleHandler<Boolean>(Boolean.class, (sb, o) -> sb.append((boolean)o)), new ContainerHandler<Collection>(Collection.class, JsonLogEntryFormatter::formatCollection), new ContainerHandler<Map>(Map.class, JsonLogEntryFormatter::formatMap), new SimpleHandler<char[]>(char[].class, JsonLogEntryFormatter::formatCharArray), new SimpleHandler<boolean[]>(boolean[].class, JsonLogEntryFormatter::formatBooleanArray), new SimpleHandler<byte[]>(byte[].class, JsonLogEntryFormatter::formatByteArray), new SimpleHandler<short[]>(short[].class, JsonLogEntryFormatter::formatShortArray), new SimpleHandler<int[]>(int[].class, JsonLogEntryFormatter::formatIntArray), new SimpleHandler<long[]>(long[].class, JsonLogEntryFormatter::formatLongArray), new SimpleHandler<float[]>(float[].class, JsonLogEntryFormatter::formatFloatArray), new SimpleHandler<double[]>(double[].class, JsonLogEntryFormatter::formatDoubleArray), new ContainerHandler<Object[]>(Object[].class, JsonLogEntryFormatter::formatObjectArray), new SimpleHandler<Object>(Object.class, JsonLogEntryFormatter::formatString));

    JsonLogEntryFormatter() {
    }

    @Override
    public String format(Object o) {
        StringBuilder sb = new StringBuilder();
        JsonLogEntryFormatter.format(sb, o, 0);
        return sb.toString();
    }

    private static void format(StringBuilder sb, Object object, int depth) {
        if (depth > JsonLogEntryFormatter.maxDepth()) {
            throw new IllegalArgumentException("Max depth of " + maxDepth + " exceeded");
        }
        HANDLERS.stream().filter(h -> h.handles(object)).findFirst().orElseThrow(IllegalStateException::new).handle(sb, object, depth);
    }

    private static void formatString(StringBuilder sb, Object value) {
        sb.append('\"');
        int startIndex = sb.length();
        sb.append(value);
        Json.escapeJson((StringBuilder)sb, (int)startIndex);
        sb.append('\"');
    }

    private static void formatNumber(StringBuilder sb, Number number) {
        double doubleValue;
        long longNumber = number.longValue();
        if (Double.compare(longNumber, doubleValue = number.doubleValue()) == 0) {
            sb.append(longNumber);
        } else {
            sb.append(doubleValue);
        }
    }

    private static void formatCollection(StringBuilder sb, Collection<?> items, int depth) {
        sb.append('[');
        boolean[] first = new boolean[]{true};
        items.forEach(item -> {
            if (first[0]) {
                first[0] = false;
            } else {
                sb.append(',');
            }
            JsonLogEntryFormatter.format(sb, item, depth + 1);
        });
        sb.append(']');
    }

    private static void formatMap(StringBuilder sb, Map<?, ?> map, int depth) {
        sb.append('{');
        boolean[] first = new boolean[]{true};
        map.forEach((key, value) -> {
            if (key == null) {
                throw new IllegalArgumentException("null key in " + map + " at depth " + depth);
            }
            if (first[0]) {
                first[0] = false;
            } else {
                sb.append(',');
            }
            JsonLogEntryFormatter.appendKeyAndColon(sb, key);
            JsonLogEntryFormatter.format(sb, value, depth + 1);
        });
        sb.append('}');
    }

    private static void formatCharArray(StringBuilder sb, char[] items) {
        sb.append('[');
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('\"');
            int startIndex = sb.length();
            sb.append(items[i]);
            Json.escapeJson((StringBuilder)sb, (int)startIndex);
            sb.append('\"');
        }
        sb.append(']');
    }

    private static void formatBooleanArray(StringBuilder sb, boolean[] items) {
        sb.append('[');
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(items[i]);
        }
        sb.append(']');
    }

    private static void formatByteArray(StringBuilder sb, byte[] items) {
        sb.append('[');
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(items[i]);
        }
        sb.append(']');
    }

    private static void formatShortArray(StringBuilder sb, short[] items) {
        sb.append('[');
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(items[i]);
        }
        sb.append(']');
    }

    private static void formatIntArray(StringBuilder sb, int[] items) {
        sb.append('[');
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(items[i]);
        }
        sb.append(']');
    }

    private static void formatLongArray(StringBuilder sb, long[] items) {
        sb.append('[');
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(items[i]);
        }
        sb.append(']');
    }

    private static void formatFloatArray(StringBuilder sb, float[] items) {
        sb.append('[');
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(items[i]);
        }
        sb.append(']');
    }

    private static void formatDoubleArray(StringBuilder sb, double[] items) {
        sb.append('[');
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(items[i]);
        }
        sb.append(']');
    }

    private static void formatObjectArray(StringBuilder sb, Object[] items, int depth) {
        sb.append('[');
        int nextDepth = depth + 1;
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            JsonLogEntryFormatter.format(sb, items[i], nextDepth);
        }
        sb.append(']');
    }

    private static void appendKeyAndColon(StringBuilder sb, Object key) {
        sb.append('\"');
        String text = String.valueOf(key);
        int keyStartIndex = sb.length();
        sb.append(text);
        Json.escapeJson((StringBuilder)sb, (int)keyStartIndex);
        sb.append('\"').append(':');
    }

    private static int maxDepth() {
        if (maxDepth == -1) {
            maxDepth = SystemProperties.getInt((String)MAX_DEPTH_PROP, (int)8);
        }
        return maxDepth;
    }

    private static final class ContainerHandler<T>
    implements Handler {
        private final Class<T> type;
        private final HandleFunc<T> handle;

        ContainerHandler(Class<T> type, HandleFunc<T> handle) {
            this.type = Objects.requireNonNull(type, "type");
            this.handle = Objects.requireNonNull(handle, "handle");
        }

        @Override
        public boolean handles(Object object) {
            return this.type.isInstance(object);
        }

        @Override
        public void handle(StringBuilder sb, Object object, int depth) {
            T t = this.type.cast(object);
            this.handle.accept(sb, t, depth);
        }

        private static interface HandleFunc<T> {
            public void accept(StringBuilder var1, T var2, int var3);
        }
    }

    private static final class SimpleHandler<T>
    implements Handler {
        private final Class<T> type;
        private final BiConsumer<StringBuilder, T> handle;

        SimpleHandler(Class<T> type, BiConsumer<StringBuilder, T> handle) {
            this.type = Objects.requireNonNull(type, "type");
            this.handle = Objects.requireNonNull(handle, "handle");
        }

        @Override
        public boolean handles(Object object) {
            return this.type.isInstance(object);
        }

        @Override
        public void handle(StringBuilder sb, Object object, int depth) {
            T t = this.type.cast(object);
            this.handle.accept(sb, (StringBuilder)t);
        }
    }

    private static class NullHandler
    implements Handler {
        private NullHandler() {
        }

        @Override
        public boolean handles(Object object) {
            return object == null;
        }

        @Override
        public void handle(StringBuilder sb, Object object, int depth) {
            sb.append("null");
        }
    }

    private static interface Handler {
        public boolean handles(Object var1);

        public void handle(StringBuilder var1, Object var2, int var3);
    }
}

