/*
 * Decompiled with CFR 0.152.
 */
package org.creekservice.api.observability.logging.structured;

import java.util.function.Consumer;
import org.creekservice.api.observability.logging.structured.Level;
import org.creekservice.api.observability.logging.structured.LogEntryCustomizer;

public interface StructuredLogger {
    public static final Consumer<LogEntryCustomizer> NO_OP_CONSUMER = customizer -> {};

    default public void trace(String message) {
        this.trace(message, NO_OP_CONSUMER);
    }

    default public void trace(String message, Consumer<LogEntryCustomizer> customizer) {
        this.log(Level.TRACE, message, customizer);
    }

    default public void debug(String message) {
        this.debug(message, NO_OP_CONSUMER);
    }

    default public void debug(String message, Consumer<LogEntryCustomizer> customizer) {
        this.log(Level.DEBUG, message, customizer);
    }

    default public void info(String message) {
        this.info(message, NO_OP_CONSUMER);
    }

    default public void info(String message, Consumer<LogEntryCustomizer> customizer) {
        this.log(Level.INFO, message, customizer);
    }

    default public void warn(String message) {
        this.warn(message, NO_OP_CONSUMER);
    }

    default public void warn(String message, Consumer<LogEntryCustomizer> customizer) {
        this.log(Level.WARN, message, customizer);
    }

    default public void error(String message) {
        this.error(message, NO_OP_CONSUMER);
    }

    default public void error(String message, Consumer<LogEntryCustomizer> customizer) {
        this.log(Level.ERROR, message, customizer);
    }

    default public void log(Level level, String message) {
        this.log(level, message, NO_OP_CONSUMER);
    }

    public void log(Level var1, String var2, Consumer<LogEntryCustomizer> var3);
}

