/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.utils.tenant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.security.utils.tenant.TenantsResolver;
import org.springframework.beans.factory.annotation.Required;

public class TenantsResolverChain
implements TenantsResolver {
    protected List<TenantsResolver> resolvers;
    protected boolean chainAllTenants;

    @Required
    public void setResolvers(List<TenantsResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public void setChainAllTenants(boolean chainAllTenants) {
        this.chainAllTenants = chainAllTenants;
    }

    @Override
    public String[] getTenants() {
        ArrayList<Object> finalTenants = null;
        for (TenantsResolver resolver : this.resolvers) {
            Object[] tenants = resolver.getTenants();
            if (!ArrayUtils.isNotEmpty((Object[])tenants)) continue;
            if (this.chainAllTenants) {
                if (finalTenants == null) {
                    finalTenants = new ArrayList<Object>();
                }
                finalTenants.addAll(Arrays.asList(tenants));
                continue;
            }
            return tenants;
        }
        return finalTenants != null ? finalTenants.toArray(new String[finalTenants.size()]) : null;
    }
}

